package com.rapid.j2ee.framework.dispatcher.configure;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.io.xml.XNode;
import com.rapid.j2ee.framework.core.io.xml.XPathParser;
import com.rapid.j2ee.framework.core.reflect.ConstructorUtils;
import com.rapid.j2ee.framework.core.utils.ClassUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.dispatcher.configure.model.Configurer;
import com.rapid.j2ee.framework.dispatcher.configure.model.ParameterMatcher;
import com.rapid.j2ee.framework.dispatcher.matcher.RequestParameterMatcher;

public class DispatcherXmlConfigurer {

	private XPathParser xPathParser;

	private List<Configurer> configurers;

	private Map<String, Class> requsetMatchers;

	public DispatcherXmlConfigurer(Resource resource, String charset) {
		try {
			postConstruct(resource.getInputStream(), charset);
		} catch (IOException e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		}
	}

	public DispatcherXmlConfigurer(InputStream is) {
		this(is, "utf-8");
	}

	public DispatcherXmlConfigurer(InputStream is, String charset) {

		this.postConstruct(is, charset);

	}

	private void postConstruct(InputStream is, String charset) {

		try {
			xPathParser = new XPathParser(is, charset);

		} catch (UnsupportedEncodingException e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		} finally {
			try {
				is.close();
			} catch (Exception e) {

			}
		}

	}

	public void parse() {

		this.parseParameterMatcherTag();

		this.parseApplicationSystemTags();

		bindRequestMatcherClassHandlerToConfigurer();
	}

	private void parseParameterMatcherTag() {

		requsetMatchers = new HashMap<String, Class>(xPathParser.evalNodes(
				"configuration/request-matchers/default-matcher").size());

		for (XNode matcher : xPathParser
				.evalNodes("configuration/request-matchers/default-matcher")) {
			requsetMatchers.put("DEF-"
					+ matcher.getStringAttribute("mode").toUpperCase(),
					ClassUtils.forName(matcher
							.getStringAttribute("class-handler")));
		}

	}

	private void parseApplicationSystemTags() {

		configurers = new ArrayList<Configurer>(xPathParser.evalNodes(
				"configuration/application-system").size());

		for (XNode node : xPathParser
				.evalNodes("configuration/application-system")) {

			parseFunctionTags(new Configurer.Builder(node), node);

		}
	}

	private void parseFunctionTags(Configurer.Builder builder, XNode node) {

		for (XNode funcNode : node.evalNodes("function")) {

			builder.setFunctionInform(funcNode);

			parseSubFunctionTags(builder, funcNode);
		}

	}

	private void parseSubFunctionTags(Configurer.Builder builder, XNode funcNode) {

		for (XNode subFuncNode : funcNode.evalNodes("sub-function")) {

			Configurer.Builder confBuilder = builder.buildClone();

			parseSubFunctionTag(confBuilder, subFuncNode);

			this.configurers.add(confBuilder.build());

		}

	}

	private void parseSubFunctionTag(Configurer.Builder confBuilder,
			XNode subFuncNode) {

		confBuilder.setSubFunctionInform(subFuncNode);

		this.parseParameterMatcherTag(confBuilder, subFuncNode);

	}

	private void parseParameterMatcherTag(Configurer.Builder confBuilder,
			XNode subFuncNode) {

		XNode matcherNode = subFuncNode.evalNode("parameter-matcher");

		Assert.notNull(matcherNode,
				"Please provide parameter-matcher under sub-function!");

		confBuilder.newParameterMatcher(matcherNode);

		parseParametersTag(confBuilder, matcherNode);

	}

	private void parseParametersTag(Configurer.Builder confBuilder,
			XNode matcherNode) {

		for (XNode parameterNode : matcherNode.evalNodes("parameter")) {
			confBuilder.addParameter(parameterNode);
		}

	}

	private void bindRequestMatcherClassHandlerToConfigurer() {

		for (Configurer conf : this.configurers) {

			conf.getParameterMatcher().setRequestParameterMatcher(this);
		}
	}

	public RequestParameterMatcher lookupRequestParameterMatcher(
			ParameterMatcher matcher) {
		return (RequestParameterMatcher) ConstructorUtils
				.newCacheInstance(this.requsetMatchers.get("DEF-"
						+ StringUtils.trimToEmpty(matcher.getMode())
								.toUpperCase()));
	}

	public List<Configurer> getConfigurers() {
		return configurers;
	}

	public static void main(String[] args) {
		try {

			DispatcherXmlConfigurer configurer = new DispatcherXmlConfigurer(
					new ClassPathResource("dispatcherXmlConfigurer.xml",
							DispatcherXmlConfigurer.class).getInputStream(),
					"utf-8");

			configurer.parse();

		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
}
