package com.rapid.j2ee.framework.dispatcher.configure.model;

import com.rapid.j2ee.framework.core.io.xml.XNode;
import com.rapid.j2ee.framework.core.utils.ObjectAnalyzer;
import com.rapid.j2ee.framework.core.utils.ObjectUtils;
import com.rapid.j2ee.framework.dispatcher.RequestDispatcherConstants;
import com.rapid.j2ee.framework.dispatcher.RequestDispatcherConstants.AccessMode;

public class Configurer implements java.io.Serializable {

	private static final long serialVersionUID = 1L;

	private String systemAppName;

	private String functionName;

	private String functionDescription;

	private String subFunctionName;

	private String subFunctionDescription;

	private String url;

	private ParameterMatcher parameterMatcher;

	private String charset;

	private String method;

	private AccessMode accessMode;

	public String getMethod() {
		return method;
	}

	public boolean isPostMethod() {
		return "Post".equalsIgnoreCase(this.method);
	}

	private void setMethod(String method) {
		this.method = method;
	}

	private Configurer() {

	}

	public String getFunctionDescription() {
		return functionDescription;
	}

	private void setFunctionDescription(String functionDescription) {
		this.functionDescription = functionDescription;
	}

	public String getFunctionName() {
		return functionName;
	}

	private void setFunctionName(String functionName) {
		this.functionName = functionName;
	}

	public ParameterMatcher getParameterMatcher() {
		return parameterMatcher;
	}

	private void setParameterMatcher(ParameterMatcher parameterMatcher) {
		this.parameterMatcher = parameterMatcher;
	}

	public String getSubFunctionDescription() {
		return subFunctionDescription;
	}

	private void setSubFunctionDescription(String subFunctionDescription) {
		this.subFunctionDescription = subFunctionDescription;
	}

	public String getSubFunctionName() {
		return subFunctionName;
	}

	private void setSubFunctionName(String subFunctionName) {
		this.subFunctionName = subFunctionName;
	}

	public String getSystemAppName() {
		return systemAppName;
	}

	private void setSystemAppName(String systemAppName) {
		this.systemAppName = systemAppName;
	}

	public String getUrl() {
		return url;
	}

	private void setUrl(String url) {
		this.url = url;
	}

	private void setCharset(String charset) {
		this.charset = charset;
	}

	public String toString() {
		return ObjectAnalyzer.toString(this);
	}

	public String getCharset() {
		return charset;
	}

	public AccessMode getAccessMode() {
		return accessMode;
	}

	private void setAccessMode(AccessMode accessMode) {
		this.accessMode = accessMode;
	}

	public static class Builder implements java.io.Serializable {

		private Configurer configurer;

		public Builder(XNode node) {
			configurer = new Configurer();
			configurer.setSystemAppName(node.getStringAttribute("name"));
			configurer.setCharset(node.getStringAttribute("charset", "utf-8"));
			configurer.setMethod("GET".equalsIgnoreCase(node
					.getStringAttribute("method")) ? "GET" : "POST");
		}

		public void setFunctionInform(XNode node) {
			configurer.setFunctionName(node.getStringAttribute("name"));
			configurer.setFunctionDescription(node
					.getStringAttribute("description"));
			configurer.setCharset(node.getStringAttribute("charset", configurer
					.getCharset()));

			if (node.hasAttributeByName("method")) {
				configurer.setMethod("GET".equalsIgnoreCase(node
						.getStringAttribute("method")) ? "GET" : "POST");
			}

		}

		public void setSubFunctionInform(XNode node) {
			configurer.setSubFunctionName(node.getStringAttribute("name"));
			configurer.setSubFunctionDescription(node
					.getStringAttribute("description"));
			configurer.setUrl(node.getStringAttribute("url"));
			configurer.setCharset(node.getStringAttribute("charset", configurer
					.getCharset()));
			if (node.hasAttributeByName("method")) {
				configurer.setMethod("GET".equalsIgnoreCase(node
						.getStringAttribute("method")) ? "GET" : "POST");
			}

			configurer.setAccessMode(RequestDispatcherConstants
					.getAccessMode(node.getStringAttribute("access-mode",
							"Unkown")));

		}

		public void newParameterMatcher(XNode node) {
			configurer.setParameterMatcher(new ParameterMatcher(node));
		}

		public void addParameter(XNode node) {
			configurer.parameterMatcher.addParameter(new Parameter(node));
		}

		public Configurer build() {
			return this.configurer;
		}

		public Builder buildClone() {
			return (Builder) ObjectUtils.cloneObject(this);
		}

	}

}
