package com.rapid.j2ee.framework.dispatcher.configure.model;

import java.util.Map;

import com.rapid.j2ee.framework.core.io.xml.XNode;
import com.rapid.j2ee.framework.core.utils.ObjectAnalyzer;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public class Parameter {

	private String name;

	private String value;

	private boolean escapeValue;

	public Parameter(XNode node) {

		this.name = node.getStringAttribute("name");
		this.value = node.getStringAttribute("value");

		escapeValue = TypeChecker.isSpecialTrue(node
				.getStringAttribute("escape-value"));
	}

	public boolean matches(Map<String, String[]> parameters) {

		if (!parameters.containsKey(this.name)) {

			return false;
		}

		if (this.escapeValue) {
			return true;
		}

		for (String paramValue : parameters.get(this.name)) {

			if (StringUtils.equalsIgnoreCase(this.value, paramValue)) {
				return true;
			}

		}

		return false;

	}

	public boolean isEscapeValue() {
		return escapeValue;
	}

	public String getName() {
		return name;
	}

	public String getValue() {
		return value;
	}

	public String toString() {
		return ObjectAnalyzer.toString(this);
	}
}
