package com.rapid.j2ee.framework.dispatcher.configure.model;

import java.util.ArrayList;
import java.util.List;

import org.springframework.util.Assert;

import com.rapid.j2ee.framework.core.io.xml.XNode;
import com.rapid.j2ee.framework.core.reflect.ConstructorUtils;
import com.rapid.j2ee.framework.core.utils.ObjectAnalyzer;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.dispatcher.configure.DispatcherXmlConfigurer;
import com.rapid.j2ee.framework.dispatcher.matcher.RequestParameterMatcher;

public class ParameterMatcher implements RequestParameterMatcherSetter {

	private String classHandler;

	private RequestParameterMatcher requestParameterMatcher;

	private String mode;

	private List<Parameter> parameters;

	public ParameterMatcher(XNode node) {

		classHandler = node.getStringAttribute("class-handler");
		this.mode = "OR".equalsIgnoreCase(node.getStringAttribute("mode")) ? "OR"
				: "AND";
		parameters = new ArrayList<Parameter>();
	}

	public String getClassHandler() {
		return classHandler;
	}

	public String getMode() {
		return mode;
	}

	public List<Parameter> getParameters() {
		return parameters;
	}

	public boolean isAndMatches() {
		return "AND".equalsIgnoreCase(this.mode);
	}

	public void addParameter(Parameter parameter) {
		this.parameters.add(parameter);
	}

	public String toString() {
		return ObjectAnalyzer.toString(this);
	}

	public boolean hasMatcherParameters() {
		return !TypeChecker.isEmpty(this.parameters);
	}

	public RequestParameterMatcher getRequestParameterMatcher() {
		return requestParameterMatcher;
	}

	public void setRequestParameterMatcher(
			DispatcherXmlConfigurer dispatcherXmlConfigurer) {

		if (!TypeChecker.isEmpty(this.classHandler)) {
			this.requestParameterMatcher = (RequestParameterMatcher) ConstructorUtils
					.newCacheInstance(this.classHandler);
			return;
		}

		this.requestParameterMatcher = dispatcherXmlConfigurer
				.lookupRequestParameterMatcher(this);

		Assert.notNull(requestParameterMatcher,
				"Please setup request parameter matcher in xml for mode "
						+ this.mode);

	}

}
