package com.rapid.j2ee.framework.dispatcher.lookup;

import java.util.Map;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

import com.rapid.j2ee.framework.dispatcher.configure.model.Configurer;

public abstract class AbstractDispatchConfigurerLookup implements
		DispatchConfigurerLookup, InitializingBean {

	public AbstractDispatchConfigurerLookup() {

		systemAppNameParameterName = "dispatchSysAppName";
	}

	public DispatchConfigurer lookup(HttpServletRequest request,
			Map<String, String[]> requestMaps) {

		if (!requestMaps.containsKey(this.systemAppNameParameterName)) {
			throw new IllegalArgumentException("Please add "
					+ systemAppNameParameterName + " in request url!");
		}

		for (Configurer configurer : dispatcherResourceConfigurer
				.getResourceConfigurers(requestMaps
						.get(systemAppNameParameterName)[0])) {

			if (!configurer.getParameterMatcher().getRequestParameterMatcher()
					.matches(request, requestMaps, configurer,
							configurer.getParameterMatcher())) {

				continue;

			}

			logger.info("Lookup Dispatch Configurer Information :"
					+ configurer.getFunctionName() + "/"
					+ configurer.getSubFunctionName() + "/"
					+ configurer.getFunctionDescription() + "/"
					+ configurer.getUrl());

			if (this.interrupt(request, requestMaps, configurer)) {

				logger
						.warn("The above dispatched configurer has been interrupted!");

				continue;
			}

			return new DispatcherConfigurerImpl(configurer, this
					.getPropertiesForDynamicValues());
		}

		throw new IllegalArgumentException(
				"Please add a configure in dispatcherXmlConfigurer.xml!");
	}

	protected abstract Properties getPropertiesForDynamicValues();

	protected boolean interrupt(HttpServletRequest request,
			Map<String, String[]> requestMaps, Configurer configurer) {
		return false;
	}

	public void afterPropertiesSet() throws Exception {

		dispatcherResourceConfigurer.loadDispatchConfigurer();
	}

	public void setDispatcherResourceConfigurer(
			DispatchResourceConfigurer dispatcherResourceConfigurer) {
		this.dispatcherResourceConfigurer = dispatcherResourceConfigurer;
	}

	public void setSystemAppNameParameterName(String systemAppNameParameterName) {
		this.systemAppNameParameterName = systemAppNameParameterName;
	}

	private DispatchResourceConfigurer dispatcherResourceConfigurer;

	private String systemAppNameParameterName = "dispatchSysAppName";

	private Log logger = LogFactory.getLog(this.getClass());

}
