package com.rapid.j2ee.framework.dispatcher.lookup;

import java.util.List;

import com.rapid.j2ee.framework.core.utils.CollectionsUtil;
import com.rapid.j2ee.framework.core.utils.ResourceUtils;
import com.rapid.j2ee.framework.dispatcher.configure.DispatcherXmlConfigurer;
import com.rapid.j2ee.framework.dispatcher.configure.model.Configurer;

public class DispatchXmlResourceConfigurer implements
		DispatchResourceConfigurer {

	private String location;

	private String charset;

	private DispatcherXmlConfigurer dispatcherXmlConfigurer;

	public DispatchXmlResourceConfigurer() {
		charset = "utf-8";
	}

	public List<Configurer> getResourceConfigurers() {
		return dispatcherXmlConfigurer.getConfigurers();
	}

	public List<Configurer> getResourceConfigurers(String systemApplicationName) {

		return CollectionsUtil.find(this.getResourceConfigurers(),
				"systemAppName", systemApplicationName);
	}

	public void loadDispatchConfigurer() {

		dispatcherXmlConfigurer = new DispatcherXmlConfigurer(ResourceUtils
				.getResource(location), this.charset);

		dispatcherXmlConfigurer.parse();

	}

	public void setCharset(String charset) {
		this.charset = charset;
	}

	public void setLocation(String location) {
		this.location = location;
	}

}
