package com.rapid.j2ee.framework.dispatcher.lookup;

import java.util.Properties;

import com.rapid.j2ee.framework.core.utils.ObjectUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.dispatcher.configure.model.Configurer;

public class DispatcherConfigurerImpl implements DispatchConfigurer {

	private Configurer configurer;

	private Properties dynamicValues;

	public DispatcherConfigurerImpl(Configurer configurer,
			Properties dynamicValues) {
		this.configurer = configurer;
		this.dynamicValues = dynamicValues;

		if (TypeChecker.isEmpty(dynamicValues)) {
			this.dynamicValues = ObjectUtils.EMTPY_PROPERTIES;
		}
	}

	public String getCharset() {
		return configurer.getCharset();
	}

	public boolean isResourceDownloaded() {
		return configurer.getAccessMode().isResourceForDownload();
	}

	public String getFunction() {
		return configurer.getFunctionName();
	}

	public String getFunctionDescription() {
		return configurer.getFunctionDescription();
	}

	public boolean isPostSubmit() {
		return configurer.isPostMethod();
	}

	public String getSubFunction() {
		return configurer.getSubFunctionName();
	}

	public String getSubFunctionDescription() {
		return configurer.getSubFunctionDescription();
	}

	public String getUrl() {

		return StringUtils.replaceAll(configurer.getUrl(), dynamicValues, "${",
				"}");
	}

	public String getSystemAppName() {
		return configurer.getSystemAppName();
	}

	public String toString() {
		return this.getUrl();
	}

}
