package com.rapid.j2ee.framework.dispatcher.matcher;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import com.rapid.j2ee.framework.dispatcher.configure.model.Configurer;
import com.rapid.j2ee.framework.dispatcher.configure.model.Parameter;
import com.rapid.j2ee.framework.dispatcher.configure.model.ParameterMatcher;

public class RequestParameterOrMatcher implements RequestParameterMatcher {

	public boolean matches(HttpServletRequest request,
			Map<String, String[]> requestMaps, Configurer configurer,
			ParameterMatcher matcher) {

		if (!matcher.hasMatcherParameters()) {
			return false;
		}

		for (Parameter parameter : matcher.getParameters()) {
			if (parameter.matches(requestMaps)) {
				return true;
			}
		}

		return false;
	}

}
