package com.rapid.j2ee.framework.dispatcher.resolve;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;

public abstract class AbstractRequestParameterResovler implements
		RequestParameterResovler {

	protected static final Set<String> SYSTEM_DISPATHER_PARAMETERS = new HashSet<String>();

	static {
		SYSTEM_DISPATHER_PARAMETERS.add("dispatchSysAppName");
		SYSTEM_DISPATHER_PARAMETERS.add("method");
	}

	public AbstractRequestParameterResovler() {

	}

	protected void addSystemDispatcherParameterForExcluded(String name) {
		SYSTEM_DISPATHER_PARAMETERS.add(name);
	}

	public boolean isExcludedParameter(String parameter) {

		return SYSTEM_DISPATHER_PARAMETERS.contains(parameter);
	}

	public final Map<String, String[]> resolve(HttpServletRequest request,
			Map<String, String[]> requestParameters) {

		Map<String, String[]> requestParametersUnlocked = new HashMap<String, String[]>(
				requestParameters);

		for (String name : requestParameters.keySet()) {

			if (this.isExcludedParameter(name)
					&& requestParametersUnlocked.containsKey(name)) {
				requestParametersUnlocked.remove(name);
			}
		}

		this.doResolveParameters(request, requestParametersUnlocked);

		return requestParametersUnlocked;
	}

	protected abstract void doResolveParameters(HttpServletRequest request,
			Map<String, String[]> requestParametersUnlocked);

}
