package com.rapid.j2ee.framework.lucene.analyzer;

import java.io.Reader;

import org.apache.lucene.analysis.Analyzer;
import org.lionsoul.jcseg.analyzer.JcsegTokenizer;
import org.lionsoul.jcseg.core.ADictionary;
import org.lionsoul.jcseg.core.DictionaryFactory;
import org.lionsoul.jcseg.core.JcsegTaskConfig;

public class JcsegAnalyzer4X extends Analyzer {
	private int mode;

	private JcsegTaskConfig config = null;

	private ADictionary dic = null;

	public JcsegAnalyzer4X(int paramInt, JcsegTaskConfig paramJcsegTaskConfig) {
		this.mode = paramInt;
		this.config = paramJcsegTaskConfig;
		this.dic = DictionaryFactory
				.createDefaultDictionary(paramJcsegTaskConfig);
	}

	public JcsegAnalyzer4X(int paramInt) {
		this.mode = paramInt;
		this.config = new JcsegTaskConfig();
		this.dic = DictionaryFactory.createDefaultDictionary(this.config);
	}

	public void setConfig(JcsegTaskConfig paramJcsegTaskConfig) {
		this.config = paramJcsegTaskConfig;
	}

	public void setDict(ADictionary paramADictionary) {
		this.dic = paramADictionary;
	}

	public JcsegTaskConfig getTaskConfig() {
		return this.config;
	}

	public ADictionary getDict() {
		return this.dic;
	}

	protected Analyzer.TokenStreamComponents createComponents(
			String paramString, Reader paramReader) {
		try {
			JcsegTokenizer localJcsegTokenizer = new JcsegTokenizer(
					paramReader, this.mode, this.config, this.dic);

			return new Analyzer.TokenStreamComponents(localJcsegTokenizer);

		} catch (Exception localException) {
			localException.printStackTrace();
		}
		return null;
	}
}
