package com.rapid.j2ee.framework.lucene.query;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public class LuceneAnalyzerTokenUtils {

	public static List<String> getTokenizedWords(String text, Analyzer analyzer) {

		List<String> tokenizedWords = new ArrayList<String>(
				1 + (text.length() / 3));

		try {

			TokenStream ts = analyzer.tokenStream("text",
					new StringReader(text));

			TokenStream tokenStream = analyzer.tokenStream(null,
					new StringReader(text));

			org.apache.lucene.analysis.tokenattributes.CharTermAttribute charTermAttribute = tokenStream
					.addAttribute(CharTermAttribute.class);
			tokenStream.reset();

			while (tokenStream.incrementToken()) {

				tokenizedWords.add(charTermAttribute.toString());
			}

		} catch (IOException e) {

		}

		return tokenizedWords;
	}
}
