package com.rapid.j2ee.framework.lucene.query;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.reflect.BeanUtils;
import com.rapid.j2ee.framework.core.reflect.ConstructorUtils;
import com.rapid.j2ee.framework.core.utils.ClassUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.lucene.LuceneConstants;
import com.rapid.j2ee.framework.lucene.analyzer.LuceneAnalyzerObjectFactory;
import com.rapid.j2ee.framework.lucene.query.highlight.LuceneSearchResultHighlighter;
import com.rapid.j2ee.framework.lucene.query.query.LuceneQuerySelector;
import com.rapid.j2ee.framework.lucene.store.LuceneConfigure;

@SuppressWarnings("unchecked")
public class LuceneResourceFSQuery extends LuceneConfigure implements
		LuceneConstants {

	protected LuceneAnalyzerObjectFactory luceneAnalyzerObjectFactory = null;

	public LuceneResourceFSQuery() {
		this.luceneAnalyzerObjectFactory = LuceneAnalyzerObjectFactory.Default_LuceneAnalyzer;
	}

	/**
	 * Lucene Document:
	 * 
	 * @param
	 * @param luceneQuerySelector
	 * @param luceneSearchResultHighlighter
	 * @param pageSize
	 * @param resultView
	 * @return
	 */
	public <T> List<T> query(String subIndexFolder,
			LuceneQuerySelector luceneQuerySelector,
			LuceneSearchResultHighlighter luceneSearchResultHighlighter,
			int pageSize, Class<T> resultView) {

		Directory dir = null;

		DirectoryReader directoryReader = null;

		try {

			dir = FSDirectory.open(new File(this.getFSDirectory(subIndexFolder)));

			directoryReader = DirectoryReader.open(dir);

			IndexSearcher indexSearcher = new IndexSearcher(directoryReader);

			Analyzer analyzer = luceneAnalyzerObjectFactory.getAnalyer();

			Query query = luceneQuerySelector.select(analyzer);

			List<T> resultList = new ArrayList<T>(pageSize);

			// 高亮最佳文档切片
			for (ScoreDoc scoreDoc : indexSearcher.search(query, pageSize).scoreDocs) {

				Document hitDocument = indexSearcher.doc(scoreDoc.doc);

				resultList.add((T) this.bindDocument(hitDocument, resultView,
						luceneSearchResultHighlighter.highlight(query,
								hitDocument, analyzer)));

			}

			return resultList;

		} catch (Exception e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		}

	}

	private Object bindDocument(Document hitDocument, Class resultView,
			String highlightContent) {

		Object result = ConstructorUtils.newInstance(resultView);

		for (IndexableField field : hitDocument.getFields()) {
			try {

				java.lang.reflect.Field classField = ClassUtils
						.getFieldByIngoreCaseFieldName(resultView,
								field.name(), true);

				if (TypeChecker.isNull(classField)) {

					Logger.warn("Bind Document Warning! Missing Field:"
							+ field.name() + " For Class "
							+ resultView.getName());

					continue;
				}

				BeanUtils
						.setProperty(result, field.name(), field.stringValue());

			} catch (Exception e) {
				Logger.warn("Bind Document Error! Field:" + field.name()
						+ " For Class " + resultView.getName());
			}
		}

		try {

			BeanUtils.setProperty(result,
					Document_Lucene_Store_FieldName_HighlightContent,
					highlightContent);

		} catch (Exception e) {
			Logger.warn("Bind Document Error! Field: highlightContent"
					+ " For Class " + resultView.getName());
		}

		return result;
	}

	public void setLuceneAnalyzerFactory(
			LuceneAnalyzerObjectFactory luceneAnalyzerFactory) {
		this.luceneAnalyzerObjectFactory = luceneAnalyzerFactory;
	}

	private static final Log Logger = LogFactory
			.getLog(LuceneResourceFSQuery.class);

}
