package com.rapid.j2ee.framework.lucene.query.highlight;

import java.io.StringReader;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.Highlighter;

import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.lucene.LuceneConstants;

public abstract class AbstractLuceneSearchResultHighlighter implements
		LuceneSearchResultHighlighter, LuceneConstants {

	private Highlighter higliHighlighter;

	private String searchItemScope;

	public AbstractLuceneSearchResultHighlighter(String searchItemScope) {
		this.searchItemScope = searchItemScope;
	}

	public AbstractLuceneSearchResultHighlighter() {
		this(Document_Lucene_Store_FieldName_Content);
	}

	protected abstract Highlighter getHighlight(Query query);

	private Highlighter getHighlighterCached(Query query) {

		if (higliHighlighter == null) {
			higliHighlighter = getHighlight(query);
		}

		return higliHighlighter;
	}

	public String highlight(Query query, Document hitDocument, Analyzer analyzer) {

		try {

			TokenStream tokenContentStream = analyzer.tokenStream(
					searchItemScope, new StringReader(hitDocument
							.get(searchItemScope)));

			String content = this.getHighlighterCached(query).getBestFragment(
					tokenContentStream, hitDocument.get(searchItemScope));

			content = StringUtils.replaceAll(content, "\n", " ");
			content = StringUtils.replaceAll(content, "\t", " ");
			content = StringUtils.replaceAll(content, "\r", " ");

			return this.formatHighlightContent(content);

		} catch (Exception e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		}

	}

	protected abstract String formatHighlightContent(String content);

}
