package com.rapid.j2ee.framework.lucene.query.highlight;

import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;

import com.rapid.j2ee.framework.core.utils.StringUtils;

public class SimpleTagSearchResultHighlighter extends
		AbstractLuceneSearchResultHighlighter {

	private String preTag;

	private String postTag;

	private int startTag;

	private int endTag;

	public SimpleTagSearchResultHighlighter(String searchItemScope,
			String preTag, String postTag) {
		this.postTag = postTag;
		this.preTag = preTag;
		this.startTag = 5;
		this.endTag = 100;

	}

	public SimpleTagSearchResultHighlighter(String preTag, String postTag) {
		this(Document_Lucene_Store_FieldName_Content, preTag, postTag);
	}

	public void setEndTag(int endTag) {
		this.endTag = endTag;
	}

	public void setStartTag(int startTag) {
		this.startTag = startTag;
	}

	@Override
	protected String formatHighlightContent(String content) {

		content = StringUtils.replaceAll(content, postTag + preTag, "");

		content = StringUtils.replaceAll(content, postTag + " " + preTag, " ");

		int index = content.indexOf(preTag);

		int startIndex = 0;

		String endFlag = "......";

		if (index > startTag) {
			startIndex = index - startTag;
		}

		int endIndex = startIndex + endTag;

		if (startIndex + endTag >= content.length()) {
			endIndex = content.length();
			endFlag = "";
		}

		return content.substring(startIndex, endIndex) + endFlag;
	}

	@Override
	protected Highlighter getHighlight(Query query) {

		SimpleHTMLFormatter simpleHTMLFormatter = new SimpleHTMLFormatter(
				preTag, postTag);

		return new Highlighter(simpleHTMLFormatter, new QueryScorer(query));

	}

}
