package com.rapid.j2ee.framework.lucene.query.query;

import java.util.List;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Query;

import com.rapid.j2ee.framework.lucene.query.LuceneAnalyzerTokenUtils;

public abstract class AbstractLuceneQuerySelector implements
		LuceneQuerySelector {

	protected String searchItem;

	public AbstractLuceneQuerySelector(String searchItem) {
		this.searchItem = searchItem;
	}

	public Query select(Analyzer analyzer) {

		return this.select(searchItem, analyzer, LuceneAnalyzerTokenUtils
				.getTokenizedWords(searchItem, analyzer));
	}

	public abstract Query select(String searchItem, Analyzer analyzer,
			List<String> indexKeywords);
}
