package com.rapid.j2ee.framework.lucene.query.query;

import java.util.List;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.springframework.util.Assert;

import com.rapid.j2ee.framework.lucene.LuceneConstants;

public class PhraseQuerySelector extends AbstractLuceneQuerySelector implements
		LuceneConstants {

	private int keywordSlop;

	private String termSearchScope;

	public PhraseQuerySelector(String searchItem, int keywordSlop,
			String termSearchScope) {
		super(searchItem);
		this.keywordSlop = keywordSlop;
		this.termSearchScope = termSearchScope;
	}

	public PhraseQuerySelector(String searchItem, int keywordSlop) {
		this(searchItem, keywordSlop, Document_Lucene_Store_FieldName_Content);
	}

	public Query select(String searchItem, Analyzer analyzer,
			List<String> indexKeywords) {

		Assert.hasLength(termSearchScope,
				"Provide a Term Search Scope! scope=content");

		PhraseQuery query = new PhraseQuery();

		query.setSlop(keywordSlop);

		for (String word : indexKeywords) {

			query.add(new Term(termSearchScope, word));
		}

		return query;
	}
}
