package com.rapid.j2ee.framework.lucene.store;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;

import com.rapid.j2ee.framework.core.utils.FileUtils;
import com.rapid.j2ee.framework.core.utils.NumberUtils;
import com.rapid.j2ee.framework.core.utils.ResourceUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.lucene.exp.LuceneStorageException;

public class LuceneConfigure {

	private Properties configures;

	private String rootDirName = "Default";

	public LuceneConfigure() {

	}

	private void initPropertiesForDefault() {

		if (configures != null) {
			return;
		}

		setLuceneConfigureLocation("lucene/luceneConfigure.properties");
	}

	public String getProperty(String name, String defaultValue) {

		initPropertiesForDefault();

		if (configures.containsKey(rootDirName + "." + name)) {
			name = rootDirName + "." + name;
		}

		return configures.getProperty(name, defaultValue);
	}

	public String getProperty(String name) {
		return getProperty(name, "");
	}

	public int getPropertyInt(String name) {
		return NumberUtils.parseInt(getProperty(name), 128);
	}

	public String getFSDirectory(String subIndexFolder) {

		if (TypeChecker.isEmpty(subIndexFolder)) {
			return getProperty("LuceneHome");
		}

		return FileUtils.getFullFilePathName(getProperty("LuceneHome"),
				subIndexFolder);
	}

	public void setLuceneConfigureLocation(String luceneConfigureLocation) {

		InputStreamReader isr = null;
		InputStream is = null;

		configures = new Properties();

		try {

			is = ResourceUtils.getResource(luceneConfigureLocation)
					.getInputStream();

			isr = new InputStreamReader(is, "utf-8");

			configures.load(isr);

		} catch (Exception e) {
			throw new LuceneStorageException("Load Properties File :"
					+ luceneConfigureLocation + " error!", e);
		} finally {

			try {
				isr.close();
				is.close();
			} catch (Exception ep) {

			}
		}

	}

	public void setRootDirName(String rootDirName) {
		this.rootDirName = rootDirName;
	}

	public String getRootDirName() {
		return rootDirName;
	}

}
