package com.rapid.j2ee.framework.lucene.store;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;

import com.rapid.j2ee.framework.core.utils.FileUtils;
import com.rapid.j2ee.framework.core.utils.ObjectUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.lucene.analyzer.LuceneAnalyzerObjectFactory;
import com.rapid.j2ee.framework.lucene.exp.LuceneStorageException;
import com.rapid.j2ee.framework.lucene.store.context.AttributeType;
import com.rapid.j2ee.framework.lucene.store.context.ResourceAttribute;
import com.rapid.j2ee.framework.lucene.store.context.ResourceContextAttribute;
import com.rapid.j2ee.framework.lucene.store.context.ResourceType;
import com.rapid.j2ee.framework.lucene.store.listener.LuceneReaderCycleListener;
import com.rapid.j2ee.framework.lucene.store.listener.LuceneResourceFSStorageCycleListener;

public class LuceneResourceFSStorage extends LuceneConfigure {

	protected Directory directory = null;

	protected LuceneAnalyzerObjectFactory luceneAnalyzerObjectFactory = null;

	protected IndexWriterConfig indexWriterConfig;

	protected IndexWriter indexWriter = null;

	private LuceneReaderCycleListener luceneReaderCycleListener;

	private static final Log logger = LogFactory
			.getLog(LuceneResourceFSStorage.class);

	private LuceneResourceFSStorageCycleListener luceneResourceFSStorageCycleListener;

	public LuceneResourceFSStorage() {
		this.luceneResourceFSStorageCycleListener = LuceneResourceFSStorageCycleListener.Default;
		this.luceneAnalyzerObjectFactory = LuceneAnalyzerObjectFactory.Default_LuceneAnalyzer;

	}

	public void queryResourceDocuments(String subIndexFolder,
			ResourceContextAttribute resourceContextAttribute, int pageCount,
			ResourceDocumentExtractor extract) {

		DirectoryReader directoryReader = null;

		Directory dir = null;

		try {

			File file = new File(this.getFSDirectory(subIndexFolder));

			if (!file.exists()) {
				return;
			}

			dir = FSDirectory.open(file);

			directoryReader = DirectoryReader.open(dir);

			Term term = new Term(resourceContextAttribute.getAttributeName(),
					resourceContextAttribute.getAttributeValue());

			IndexSearcher indexSearcher = new IndexSearcher(directoryReader);

			Query query = new TermQuery(term);

			ScoreDoc[] scoreDocs = indexSearcher.search(query, pageCount).scoreDocs;

			if (TypeChecker.isEmpty(scoreDocs)) {
				return;
			}

			for (ScoreDoc scoreDoc : scoreDocs) {

				extract.extract(indexSearcher, scoreDoc, indexSearcher
						.doc(scoreDoc.doc));
			}

		} catch (Exception e) {

		} finally {
			try {
				directoryReader.close();
			} catch (Exception e) {

			}
			try {
				dir.close();
			} catch (Exception e) {

			}
		}

	}

	public synchronized void createOrUpdateResourceIndexes(
			String subIndexFolder, ResourceAttribute resourceAttribute,
			List<ResourceContextAttribute> resourceContextAttributes) {

		luceneResourceFSStorageCycleListener.createOrUpdateResourceIndexed(
				this, subIndexFolder, resourceAttribute,
				resourceContextAttributes);

		try {

			this.prepareWithoutOpenDir(subIndexFolder);

			this.indexResource(subIndexFolder, resourceAttribute,
					resourceContextAttributes);

		} catch (Exception e) {

			e.printStackTrace();

			try {
				this.indexWriter.rollback();
			} catch (Exception ep) {

			}

			throw new LuceneStorageException(e);
		}

	}

	public synchronized void removeResourceIndexes(String subIndexFolder,
			ResourceContextAttribute resourceIdContextAttribute) {

		try {

			this.prepareWithoutOpenDir(subIndexFolder);

			ResourceAttribute resourceAttribute = new ResourceAttribute();
			resourceAttribute
					.setResourceIdContextAttribute(resourceIdContextAttribute);

			luceneReaderCycleListener.setResource(this
					.getFSDirectory(subIndexFolder), resourceAttribute,
					ObjectUtils.EMPTY_LIST);

			luceneReaderCycleListener.remove();

		} catch (Exception e) {

			try {
				this.indexWriter.rollback();
			} catch (Exception ep) {

			}

			throw new LuceneStorageException(e);
		}
	}

	public synchronized void close() {

		try {
			indexWriter.close();
		} catch (Exception e) {

		}

		try {
			directory.close();
		} catch (Exception e) {

		}

		directory = null;

		this.luceneResourceFSStorageCycleListener.closeIndexWriteDiretory(this);

	}

	private void indexResource(String subIndexFolder,
			ResourceAttribute resourceAttribute,
			List<ResourceContextAttribute> resourceContextAttributes) {

		luceneReaderCycleListener.setResource(this
				.getFSDirectory(subIndexFolder), resourceAttribute,
				resourceContextAttributes);

		System.out.println("	resourceAttribute.getResourceType() == "
				+ resourceAttribute.getResourceType());

		resourceAttribute.getResourceType().getResourceReader(
				resourceAttribute, luceneReaderCycleListener).read();

		logger.info("Add New Indexes for Document "
				+ resourceAttribute.getResourceFile() + " in "
				+ this.getFSDirectory(subIndexFolder));

	}

	private void prepareWithoutOpenDir(String subIndexFolder)
			throws IOException {

		if (directory != null) {
			return;
		}

		this.openDirectory(subIndexFolder);

		this.prepareIndexWriterConfig();

		indexWriter = new IndexWriter(directory, this.indexWriterConfig);

		luceneReaderCycleListener = new LuceneReaderCycleListener(indexWriter);

		luceneResourceFSStorageCycleListener.openDirectoryForWrite(this,
				subIndexFolder);
	}

	public void setLuceneAnalyzerFactory(
			LuceneAnalyzerObjectFactory luceneAnalyzerFactory) {
		this.luceneAnalyzerObjectFactory = luceneAnalyzerFactory;
	}

	protected void openDirectory(String subIndexFolder) throws IOException {

		File file = new File(this.getFSDirectory(subIndexFolder));

		FileUtils.makeDir(file);

		directory = FSDirectory.open(file);

	}

	protected void prepareIndexWriterConfig() {

		this.indexWriterConfig = new IndexWriterConfig(Version.LUCENE_43,
				luceneAnalyzerObjectFactory.getAnalyer());

		if (!StringUtils.isEmpty(this.getProperty("RAMBufferSizeMB"))) {

			// Optional: for better indexing performance, if you
			// are indexing many documents, increase the RAM
			// buffer. But if you do this, increase the max heap
			// size to the JVM (eg add -Xmx512m or -Xmx1g):
			//
			indexWriterConfig.setRAMBufferSizeMB(this
					.getPropertyInt("RAMBufferSizeMB"));

			logger.info("Set Index Writer Configure's  RAM Buffer Size"
					+ this.getPropertyInt("RAMBufferSizeMB") + "MB");
		}
	}

	public void setLuceneResourceFSStorageCycleListener(
			LuceneResourceFSStorageCycleListener luceneResourceFSStorageCycleListener) {
		this.luceneResourceFSStorageCycleListener = luceneResourceFSStorageCycleListener;
	}

	public static void main(String[] args) {

		LuceneResourceFSStorage luceneResourceFSStorage = new LuceneResourceFSStorage();

		// ResourceAttribute resourceAttribute = new ResourceAttribute();
		// resourceAttribute.setAttributeName("content");
		// resourceAttribute.setResourceFile(new
		// File("Y:/CPA/CPA2012A_2_30.pdf"));
		// resourceAttribute.setResourceType(ResourceType.PDF);
		//
		// ResourceContextAttribute resourceIdContextAttribute = new
		// ResourceContextAttribute();
		// resourceIdContextAttribute.setAttributeName("id");
		// resourceIdContextAttribute.setAttributeType(AttributeType.String);
		// resourceIdContextAttribute.setAttributeValue(resourceAttribute
		// .getResourceFile().getName());
		// resourceAttribute
		// .setResourceIdContextAttribute(resourceIdContextAttribute);
		//
		// List<ResourceContextAttribute> resourceContextAttributes = new
		// ArrayList<ResourceContextAttribute>();
		//
		// resourceIdContextAttribute = new ResourceContextAttribute();
		// resourceIdContextAttribute.setAttributeName("keyword");
		// resourceIdContextAttribute.setAttributeType(AttributeType.Text);
		// resourceIdContextAttribute
		// .setAttributeValue("于德惠 cpa 会计 价值真题班 2012年真题-a卷 第二段 30页");
		//
		// resourceContextAttributes.add(resourceIdContextAttribute);
		//
		// luceneResourceFSStorage.createOrUpdateResourceIndexes(
		// resourceAttribute, resourceContextAttributes);
		//
		//
		//
		//
		//
		// resourceAttribute = new ResourceAttribute();
		// resourceAttribute.setAttributeName("content");
		// resourceAttribute.setResourceFile(new
		// File("Y:/CPA/CPA2012A_7_28.pdf"));
		// resourceAttribute.setResourceType(ResourceType.PDF);
		//
		// resourceIdContextAttribute = new ResourceContextAttribute();
		// resourceIdContextAttribute.setAttributeName("id");
		// resourceIdContextAttribute.setAttributeType(AttributeType.String);
		// resourceIdContextAttribute.setAttributeValue(resourceAttribute
		// .getResourceFile().getName());
		// resourceAttribute
		// .setResourceIdContextAttribute(resourceIdContextAttribute);
		//
		// resourceContextAttributes = new
		// ArrayList<ResourceContextAttribute>();
		//
		// resourceIdContextAttribute = new ResourceContextAttribute();
		// resourceIdContextAttribute.setAttributeName("keyword");
		// resourceIdContextAttribute.setAttributeType(AttributeType.Text);
		// resourceIdContextAttribute
		// .setAttributeValue("于德惠 cpa 会计 价值真题班 2012年真题 a卷 第七段 28页");
		//
		// resourceContextAttributes.add(resourceIdContextAttribute);
		//
		// luceneResourceFSStorage.createOrUpdateResourceIndexes(
		// resourceAttribute, resourceContextAttributes);
		//
		//

		for (File file : new File(
				"G:\\Workspace(JohnHao)\\ABIT\\eMap\\documents\\SmartReader")
				.listFiles()) {

			ResourceAttribute resourceAttribute = new ResourceAttribute();
			resourceAttribute.setAttributeName("content");
			resourceAttribute.setResourceFile(file);
			resourceAttribute.setResourceType(ResourceType.PDF);

			ResourceContextAttribute resourceIdContextAttribute = new ResourceContextAttribute();
			resourceIdContextAttribute.setAttributeName("id");
			resourceIdContextAttribute.setAttributeType(AttributeType.String);
			resourceIdContextAttribute.setAttributeValue(resourceAttribute
					.getResourceFile().getName());
			resourceAttribute
					.setResourceIdContextAttribute(resourceIdContextAttribute);

			List<ResourceContextAttribute> resourceContextAttributes = new ArrayList<ResourceContextAttribute>();

			resourceIdContextAttribute = new ResourceContextAttribute();
			resourceIdContextAttribute.setAttributeName("keyword");
			resourceIdContextAttribute.setAttributeType(AttributeType.Text);
			resourceIdContextAttribute.setAttributeValue(file.getName());

			resourceContextAttributes.add(resourceIdContextAttribute);

			luceneResourceFSStorage.createOrUpdateResourceIndexes("",
					resourceAttribute, resourceContextAttributes);

		}

		luceneResourceFSStorage.close();

	}

}
