package com.rapid.j2ee.framework.lucene.store.context;

import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatField;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;

public enum AttributeType {

	Long {
		@Override
		public Field getField(ResourceContextAttribute resourceContextAttribute) {

			return new LongField(resourceContextAttribute.getAttributeName(),
					java.lang.Long.parseLong(resourceContextAttribute
							.getAttributeValue()),
					resourceContextAttribute.getFieldStore());
		}
	},
	Int {
		@Override
		public Field getField(ResourceContextAttribute resourceContextAttribute) {

			return new IntField(resourceContextAttribute.getAttributeName(),
					java.lang.Integer.parseInt(resourceContextAttribute
							.getAttributeValue()),
					resourceContextAttribute.getFieldStore());
		}
	},
	Double {
		@Override
		public Field getField(ResourceContextAttribute resourceContextAttribute) {

			return new DoubleField(resourceContextAttribute.getAttributeName(),
					java.lang.Double.parseDouble(resourceContextAttribute
							.getAttributeValue()),
					resourceContextAttribute.getFieldStore());
		}
	},
	Float {
		@Override
		public Field getField(ResourceContextAttribute resourceContextAttribute) {

			return new FloatField(resourceContextAttribute.getAttributeName(),
					java.lang.Float.parseFloat(resourceContextAttribute
							.getAttributeValue()),
					resourceContextAttribute.getFieldStore());
		}
	},
	String {
		@Override
		public Field getField(ResourceContextAttribute resourceContextAttribute) {

			return new StringField(resourceContextAttribute.getAttributeName(),
					resourceContextAttribute.getAttributeValue(),
					resourceContextAttribute.getFieldStore());
		}
	},
	Text {
		@Override
		public Field getField(ResourceContextAttribute resourceContextAttribute) {

			return new TextField(resourceContextAttribute.getAttributeName(),
					resourceContextAttribute.getAttributeValue(),
					resourceContextAttribute.getFieldStore());
		}
	};

	public abstract Field getField(
			ResourceContextAttribute resourceContextAttribute);
}
