package com.rapid.j2ee.framework.lucene.store.context;

import com.rapid.j2ee.framework.core.utils.Constants;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.lucene.stream.ResourceReader;
import com.rapid.j2ee.framework.lucene.stream.ResourceReaderCycleListener;
import com.rapid.j2ee.framework.lucene.stream.pdf.PdfReader;
import com.rapid.j2ee.framework.lucene.stream.text.TextReader;

public enum ResourceType {

	PDF {
		@Override
		public ResourceReader getResourceReader(
				ResourceAttribute resourceAttribute,
				ResourceReaderCycleListener resourceReaderCycleListener) {

			return new PdfReader(resourceAttribute.getResourceFile(),
					resourceReaderCycleListener);
		}

		@Override
		public boolean isFileResource() {

			return true;
		}
	},

	TEXT {
		@Override
		public ResourceReader getResourceReader(
				ResourceAttribute resourceAttribute,
				ResourceReaderCycleListener resourceReaderCycleListener) {

			return new TextReader(resourceAttribute,
					resourceReaderCycleListener);
		}

		@Override
		public boolean isFileResource() {

			return false;
		}
	};

	private static Constants ResourceTypeConstant = new Constants(
			ResourceType.class, true);

	public abstract ResourceReader getResourceReader(
			ResourceAttribute resourceAttribute,
			ResourceReaderCycleListener resourceReaderCycleListener);

	public abstract boolean isFileResource();

	public static ResourceType getResourceType(String type) {
		return (ResourceType) ResourceTypeConstant.asObject(StringUtils
				.trimToEmpty(type).toUpperCase());
	}

	public static void main(String[] args) {

		System.out.println(ResourceType.getResourceType("pdf"));
	}
}
