package com.rapid.j2ee.framework.lucene.store.listener;

import java.util.List;

import com.rapid.j2ee.framework.lucene.store.LuceneResourceFSStorage;
import com.rapid.j2ee.framework.lucene.store.context.ResourceAttribute;
import com.rapid.j2ee.framework.lucene.store.context.ResourceContextAttribute;

public interface LuceneResourceFSStorageCycleListener {

	public void createOrUpdateResourceIndexed(LuceneResourceFSStorage storage,
			String subFolderName, ResourceAttribute resourceAttribute,
			List<ResourceContextAttribute> resourceContextAttributes);

	public void closeIndexWriteDiretory(LuceneResourceFSStorage storage);

	public void openDirectoryForWrite(LuceneResourceFSStorage storage,
			String subFolderName);

	public static final LuceneResourceFSStorageCycleListener Default = new LuceneResourceFSStorageCycleListener() {

		public void openDirectoryForWrite(LuceneResourceFSStorage storage,
				String subFolderName) {
			System.out
					.println("openDirectoryForWrite() method for Root Dir Name:"
							+ storage.getRootDirName()
							+ " Directory："
							+ storage.getFSDirectory(subFolderName));

		}

		public void closeIndexWriteDiretory(LuceneResourceFSStorage storage) {

			System.out
					.println("closeIndexWriteDiretory() method for Root Dir Name:"
							+ storage.getRootDirName());

		}

		public void createOrUpdateResourceIndexed(
				LuceneResourceFSStorage storage, String subFolderName,
				ResourceAttribute resourceAttribute,
				List<ResourceContextAttribute> resourceContextAttributes) {

			System.out
					.println("createOrUpdateResourceIndexed() method for Root Dir Name:"
							+ storage.getRootDirName()
							+ " Directory："
							+ storage.getFSDirectory(subFolderName));

		}

	};

}
