package com.rapid.j2ee.framework.lucene.stream;

import java.io.File;

import org.springframework.util.Assert;

import com.rapid.j2ee.framework.lucene.exp.ResourceReaderException;

public abstract class AbstractResourceReader implements ResourceReader {

	protected File resourceFile;

	protected ResourceReaderCycleListener resourceReaderCycleListener;

	public AbstractResourceReader(File resourceFile,
			ResourceReaderCycleListener resourceReaderCycleListener) {
		this.resourceFile = resourceFile;
		this.resourceReaderCycleListener = resourceReaderCycleListener;

	}

	private void checkResourceAvailable() {

		Assert.notNull(resourceReaderCycleListener,
				"Please provide a ResourceReaderCycleListener !");

		Assert.notNull(resourceFile, "Please provide a file !");

		if (resourceFile.isDirectory() || !resourceFile.canRead()) {
			Assert.notNull(resourceFile, "Please provide a readable file :"
					+ this.resourceFile);
		}

	}

	public void read() {

		this.checkResourceAvailable();

		try {
			this.doRead(resourceFile, resourceReaderCycleListener);
		} catch (Exception e) {
			throw new ResourceReaderException(e);
		}
	}

	protected abstract void doRead(File resourceFile,
			ResourceReaderCycleListener resourceReaderCycleListener)
			throws Exception;
}
