package com.rapid.j2ee.framework.lucene.stream.pdf;

import java.io.File;

import com.itextpdf.text.pdf.parser.PdfTextExtractor;
import com.rapid.j2ee.framework.lucene.stream.AbstractResourceReader;
import com.rapid.j2ee.framework.lucene.stream.ResourceReaderCycleListener;

public class PdfReader extends AbstractResourceReader {

	public PdfReader(File resourceFile,
			ResourceReaderCycleListener resourceReaderCycleListener) {
		super(resourceFile, resourceReaderCycleListener);
	}

	@Override
	protected void doRead(File resourceFile,
			ResourceReaderCycleListener resourceReaderCycleListener)
			throws Exception {

		com.itextpdf.text.pdf.PdfReader pdfReader = null;

		try {

			if (!resourceReaderCycleListener.open()) {

				return;
			}

			pdfReader = new com.itextpdf.text.pdf.PdfReader(resourceFile
					.getAbsolutePath());

			int totalNumber = pdfReader.getNumberOfPages();

			for (int i = 1; i <= totalNumber; i++) {

				resourceReaderCycleListener.read(i, totalNumber,
						PdfTextExtractor.getTextFromPage(pdfReader, i));
			}

		} finally {
			try {
				pdfReader.close();
			} catch (Exception e) {

			}

			resourceReaderCycleListener.close();

		}

	}

}
