package com.rapid.j2ee.framework.lucene.stream.text;

import java.io.File;

import com.rapid.j2ee.framework.lucene.exp.ResourceReaderException;
import com.rapid.j2ee.framework.lucene.store.context.ResourceAttribute;
import com.rapid.j2ee.framework.lucene.stream.AbstractResourceReader;
import com.rapid.j2ee.framework.lucene.stream.ResourceReader;
import com.rapid.j2ee.framework.lucene.stream.ResourceReaderCycleListener;

public class TextReader implements ResourceReader {

	public TextReader(ResourceAttribute resourceAttribute,
			ResourceReaderCycleListener resourceReaderCycleListener) {

		this.resourceReaderCycleListener = resourceReaderCycleListener;
		this.resourceAttribute = resourceAttribute;
	}

	public void read() {

		try {
			if (!resourceReaderCycleListener.open()) {

				return;
			}

			resourceReaderCycleListener.read(1, 1, resourceAttribute
					.getResourceContent());

		} catch (Exception e) {
			throw new ResourceReaderException(e);
		} finally {

			try {
				resourceReaderCycleListener.close();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	private ResourceReaderCycleListener resourceReaderCycleListener;

	private ResourceAttribute resourceAttribute;

}
