package com.rapid.j2ee.framework.mvc.constants;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

import com.rapid.j2ee.framework.core.utils.ClassUtils;

public class OperationResultConstants implements OperationResult {

	public final static OperationResult SUCCESS_OPERATION = new OperationResultConstants(
			OperationResult.Success, "I000000", "Success Operation!");

	// X 01-10 操作成功Code
	public final static OperationResult SUCCESS_SUBMIT_INSERT = new OperationResultConstants(
			OperationResult.Success, "I000001", "New Record Successfully!");

	public final static OperationResult SUCCESS_SUBMIT_UPDATE = new OperationResultConstants(
			OperationResult.Success, "I000002", "Upload Record Successfully!");

	public final static OperationResult SUCCESS_SUBMIT_DELETE = new OperationResultConstants(
			OperationResult.Success, "I000003", "Delete Record Successfully!");

	public final static OperationResult SUCCESS_SUBMIT_SEARCH = new OperationResultConstants(
			OperationResult.Success, "I000004", "Search Successfully!");

	public final static OperationResult SUCCESS_SUBMIT_UPLOAD = new OperationResultConstants(
			OperationResult.Success, "I000005", "Upload File Successfully!");

	public final static OperationResult SUCCESS_SUBMIT_DOWNLOAD = new OperationResultConstants(
			OperationResult.Success, "I000006", "Download File Successfully!");

	public final static OperationResult SUCCESS_SUBMIT_SAVE = new OperationResultConstants(
			OperationResult.Success, "I000007", "Save Data Successfully!");

	public final static OperationResult SUCCESS_SUBMIT_COPY = new OperationResultConstants(
			OperationResult.Success, "I000008", "Copy Data Successfully!");

	public final static OperationResult SUCCESS_SUBMIT_CROP = new OperationResultConstants(
			OperationResult.Success, "I000009", "Crop Data Successfully!");

	public final static OperationResult SUCCESS_SUBMIT_CANCEL = new OperationResultConstants(
			OperationResult.Success, "I000009001", "Cancel Successfully!");

	public final static OperationResult SUCCESS_SUBMIT_DRAFT = new OperationResultConstants(
			OperationResult.Success, "I000009002", "Draft Successfully!");

	// 10-20 Login Error
	public final static OperationResult SUCCESS_LOGIN = new OperationResultConstants(
			OperationResult.Success, "I000010", "Login Successfully!");

	public final static OperationResult FAILED_LOGIN_NOT_EXISTED_USERID = new OperationResultConstants(
			OperationResult.Security_Warning, "I000011",
			"User Id Does Not Exist By Wrong User Id!");

	public final static OperationResult FAILED_LOGIN_WRONG_PASSWORD = new OperationResultConstants(
			OperationResult.Security_Warning, "I000012",
			"User Password is Wrong!");

	public final static OperationResult FAILED_LOGIN_ACCOUNT_TERMIATED = new OperationResultConstants(
			OperationResult.Security_Warning, "I000013",
			"User Account is Terminated!");

	public final static OperationResult FAILED_LOGIN_DUPLICATED_EXISTED_USERID = new OperationResultConstants(
			OperationResult.Security_Warning, "I000014",
			"User Id Duplicated Exist By Wrong User Id!");

	public final static OperationResult FAILED_LOGIN_USERID_AUDIT_STAGE1 = new OperationResultConstants(
			OperationResult.Security_Warning, "I000015",
			"User Id is audted at stage 1!");

	public final static OperationResult FAILED_LOGIN_USERID_AUDIT_STAGE2 = new OperationResultConstants(
			OperationResult.Security_Warning, "I000016",
			"User Id is audted at stage 2!");

	public final static OperationResult FAILED_LOGIN_USERID_AUDIT_STAGE3 = new OperationResultConstants(
			OperationResult.Security_Warning, "I000017",
			"User Id is audted at stage 3!");

	public final static OperationResult FAILED_LOGIN_USERID_LOCKED = new OperationResultConstants(
			OperationResult.Security_Warning, "I000018", "User Id is locked!");

	public final static OperationResult SUCCESS_LOGOUT = new OperationResultConstants(
			OperationResult.Success, "I000019", "Logout Successfully!");

	// 20-40 操作数据ErrorCode
	public final static OperationResult FAILED_SUBMIT_SEARCH_NO_RECORDS = new OperationResultConstants(
			OperationResult.NoData_Warning, "I000020", "No Records Found!");

	public final static OperationResult FAILED_SUBMIT_UPLOAD_EXCEED_MAX_LIMITED_SIZE = new OperationResultConstants(
			OperationResult.Business_Warning, "I000021",
			"Exceed Max Limited File Size Uploaded!");

	public final static OperationResult FAILED_SUBMIT_SEARCH_NO_RECORD_BY_PRIMARYKEY = new OperationResultConstants(
			OperationResult.Business_Warning, "I000022",
			"No Record Found and Record Should be deleted Now!");

	public final static OperationResult FAILED_UP_LIMITATION_COUNTS_BY_SEARCH = new OperationResultConstants(
			OperationResult.Business_Warning, "I000023",
			"There are too many results, please specify more detail query criteria!");

	public final static OperationResult FAILED_BUSINESS_DATA_VALIDATION = new OperationResultConstants(
			OperationResult.Business_Warning, "I000025",
			"Failure Data Validation");

	public final static OperationResult WARNGING_APPLICATION_DATA = new OperationResultConstants(
			OperationResult.Business_Warning, "I000026",
			"Business Warning Data!");

	public final static OperationResult FAILED_BUSINESS_DATA_VALIDATION2 = new OperationResultConstants(
			OperationResult.Business_Warning, "I000027",
			"Failure Data Validation2");

	public final static OperationResult FAILED_BUSINESS_DATA_VALIDATION3 = new OperationResultConstants(
			OperationResult.Business_Warning, "I000028",
			"Failure Data Validation3");

	public final static OperationResult FAILED_BUSINESS_DATA_VALIDATION4 = new OperationResultConstants(
			OperationResult.Business_Warning, "I000029",
			"Failure Data Validation4");

	public final static OperationResult FAILED_BUSINESS_DATA_VALIDATION5 = new OperationResultConstants(
			OperationResult.Business_Warning, "I000030",
			"Failure Data Validation5");

	public final static OperationResult FAILED_BUSINESS_DATA_VALIDATION6 = new OperationResultConstants(
			OperationResult.Business_Warning, "I000031",
			"Failure Data Validation6");

	public final static OperationResult FAILED_SUBMIT_UPLOAD_NOT_ALLOW_TYPES = new OperationResultConstants(
			OperationResult.Business_Warning, "I000032",
			"File Uploaded Not Allow Types!");

	public final static OperationResult FAILED_RESOURCE_NOT_FOUND = new OperationResultConstants(
			OperationResult.Business_Warning, "I000033",
			"File & Resource Not Found!");

	public final static OperationResult FAILED_SUBMIT_UPLOAD_RESOURCE_ERROR = new OperationResultConstants(
			OperationResult.Business_Warning, "I000034", "File Upload Error!");

	public final static OperationResult FAILED_PARAMETER_VALIDATION = new OperationResultConstants(
			OperationResult.Business_Warning, "I000035",
			"Failure Request Parameter Validation Error 1");

	public final static OperationResult FAILED_PARAMETER_VALIDATION2 = new OperationResultConstants(
			OperationResult.Business_Warning, "I000036",
			"Failure Request Parameter Validation Error 2");

	public final static OperationResult FAILED_PARAMETER_VALIDATION3 = new OperationResultConstants(
			OperationResult.Business_Warning, "I000037",
			"Failure Request Parameter Validation Error 3");

	public final static OperationResult FAILED_PARAMETER_INVALID_HANDLER_VALIDATION = new OperationResultConstants(
			OperationResult.Business_Warning, "I000038",
			"Failure Request Parameter Validation Error - Invalide Handler ");

	public final static OperationResult FAILED_PARAMETER_INVALID_HANDLER_VALIDATION2 = new OperationResultConstants(
			OperationResult.Business_Warning, "I000039",
			"Failure Request Parameter Validation Error - Invalide Handler2 ");

	// 40-60 数据库Error
	public final static OperationResult FAILED_DATABASE_CONNECTION_ERROR = new OperationResultConstants(
			OperationResult.Database_Error, "I000040",
			"Database Cannot be Connected to!");

	public final static OperationResult FAILED_DATABASE_PRIMARYKEY_DUPLICATION_ERROR = new OperationResultConstants(
			OperationResult.Database_Warning, "I000041", "Record Existed Now!");

	public final static OperationResult FAILED_DATABASE_BUSINESS_DUPLICATION_ERROR = new OperationResultConstants(
			OperationResult.Database_Warning, "I000042",
			"Record is Duplicated Now!");

	public final static OperationResult FAILED_DATABASE_PRIMARYKEY_MANY_RECORDS_ERROR = new OperationResultConstants(
			OperationResult.Database_Warning, "I000043",
			"Record is too many by primary key search!");

	// Action / Service Error 60-80
	public final static OperationResult FAILED_OPERATE_RUNTIME_ERROR = new OperationResultConstants(
			OperationResult.System_Error, "I000060", "Runtime Exception Error!");

	public final static OperationResult FAILED_SESSION_TIMEOUT_ERROR = new OperationResultConstants(
			OperationResult.Security_Warning_SessionTimeout, "I000061",
			"Session is timeout!");

	public final static OperationResult FAILED_NO_PERMISSION_ACCESSIBLE_ERROR = new OperationResultConstants(
			OperationResult.Security_Warning_NoPermission_Access, "I000062",
			"Not Allowed to Access!");

	public final static OperationResult FAILED_NO_ANY_PERMISSION_ACCESSIBLE_ERROR = new OperationResultConstants(
			OperationResult.Security_Warning_NoPermission_Access, "I000063",
			"Not Any Accessible Function Points!");

	public final static OperationResult FAILED_NO_ANY_RESOURCE_MENU_ERROR = new OperationResultConstants(
			OperationResult.Security_Warning_NoPermission_Access, "I000064",
			"Not Any Accessible Menus!");

	public final static OperationResult FAILED_NO_ANY_ORGANIZATION_ASSOCIATION_ERROR = new OperationResultConstants(
			OperationResult.Security_Warning_NoPermission_Access, "I000065",
			"Not Any Accessible Organizations!");

	public final static OperationResult FAILED_VERIFICATION_CODE_ERROR = new OperationResultConstants(
			OperationResult.Security_Warning_NoPermission_Access, "I000066",
			"Verification Code Error!");

	// 短信70-77
	public final static OperationResult FAILED_SMS_INVALID_MOBILENO = new OperationResultConstants(
			OperationResult.Business_Warning, "I000070", "接收短信的手机号码为空!");

	public final static OperationResult FAILED_SMS_SERVICE_CLOSED = new OperationResultConstants(
			OperationResult.Business_Warning, "I000071", "应用未开通短信功能");

	public final static OperationResult FAILED_SMS_SERVICE_SEND = new OperationResultConstants(
			OperationResult.Business_Warning, "I000072", "发送短信Error");

	public final static OperationResult FAILED_SMS_SERVICE_SECURITY = new OperationResultConstants(
			OperationResult.Business_Warning, "I000073", "发送短信用户名或密码错误！");

	public final static OperationResult FAILED_SMS_SERVICE_NOT_ENOUGH_BALANCE = new OperationResultConstants(
			OperationResult.Business_Warning, "I000074", "发送短信余额不够 ！");

	public final static OperationResult FAILED_SMS_SERVICE_CONTENT_LIMIT = new OperationResultConstants(
			OperationResult.Business_Warning, "I000075", "发送内容超长！");

	public final static OperationResult FAILED_SMS_LOST_SIGN = new OperationResultConstants(
			OperationResult.Business_Warning, "I000076", "发送内容缺少【签名】！");

	public final static OperationResult FAILED_SMS_ERROR_VERFICATIONCODE = new OperationResultConstants(
			OperationResult.Business_Warning, "I000077", "发送短信缺少校验码!");

	public final static OperationResult FAILED_SMS_MOBILENO_EXISTS = new OperationResultConstants(
			OperationResult.Business_Warning, "I000078", "手机号码已经存在!");

	// OAuth2............................ Start
	public final static OperationResult FAILED_OAUTH2_PLATFORM_CONFIGURE_MISS = new OperationResultConstants(
			OperationResult.Security_Error_OAuth2, "I000090",
			"Your platform is missed, please configure it before use OAuth2!");

	public final static OperationResult FAILED_OAUTH2_PLATFORM_SECRET_ERROR = new OperationResultConstants(
			OperationResult.Security_Error_OAuth2, "I000091",
			"Your platform password error!");

	public final static OperationResult FAILED_OAUTH2_REFRESH_TOKEN_WRONG = new OperationResultConstants(
			OperationResult.Security_Error_OAuth2, "I000092",
			"Your refresh token id is wrong!");

	public final static OperationResult FAILED_OAUTH2_ILLEGAL_AUTHOIRTY_CODE = new OperationResultConstants(
			OperationResult.Business_Error, "I000093",
			"Your authority code is illegal!");

	// OAuth2............................ End

	public final static OperationResult FAILED_APPLICATION_VERSION_EXPIRED = new OperationResultConstants(
			OperationResult.Security_Error_ApplicationVersionExpired,
			"I000080", "Your Application Version is Expired!");

	public final static OperationResult FAILED_LOST_ACTION_METHOD_ERROR = new OperationResultConstants(
			OperationResult.System_Error, "I900001", "Lost Action Method!");

	public final static OperationResult FAILED_LOST_ACTION_MVC_METHOD_CONFIGURER_ERROR = new OperationResultConstants(
			OperationResult.System_Error, "I900002",
			"MvcMethodConfigurer Lost!");

	public final static OperationResult FAILED_SECURITY_SN_ERROR = new OperationResultConstants(
			OperationResult.Security_Warning_SN_Failure, "I900010",
			"安全序列号SN与HashCode无法比配!");

	public final static OperationResult FAILED_SECURITY_SN_EXPIRED = new OperationResultConstants(
			OperationResult.Security_Warning_SN_Failure, "I900011",
			"安全序列号SN已经过期!");

	public final static OperationResult FAILED_SECURITY_SN_LOST = new OperationResultConstants(
			OperationResult.Security_Warning_SN_Failure, "I900012",
			"安全序列号SN Lost!");

	private int resultCode;

	private String messageCode;

	private String messageDefault;

	protected OperationResultConstants(int resultCode, String messageCode,
			String msgDefValue) {
		this.resultCode = resultCode;
		this.messageCode = messageCode;
		this.messageDefault = msgDefValue;
	}

	public String getMessageCode() {

		return this.messageCode;
	}

	public String getMessageDefault() {

		return this.messageDefault;
	}

	public int getResultCode() {

		return this.resultCode;
	}

	public boolean isSuccess() {

		return this.resultCode == OperationResult.Success;
	}

	public static Map<String, OperationResult> getOperationResultMap(
			Class operationResultConstantClazz, boolean deepFetch) {

		Map<String, OperationResult> results = new HashMap<String, OperationResult>();

		Field[] fields = ClassUtils
				.getAllFieldsAsClass(operationResultConstantClazz);

		if (!deepFetch) {
			fields = operationResultConstantClazz.getDeclaredFields();
		}

		for (Field f : fields) {

			try {

				if (!OperationResult.class.isAssignableFrom(f.getType())) {
					continue;
				}

				OperationResultConstants result = (OperationResultConstants) f
						.get(null);

				results.put(result.getMessageCode(), result);

			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		return results;

	}

	public static boolean isFailureCode(int code) {
		return code == OperationResult.System_Error
				|| code == OperationResult.Database_Error
				|| code == OperationResult.Business_Error;
	}

	@Override
	public String toString() {
		return "ResultCode:" + this.resultCode + "Message Code:"
				+ this.messageCode + " Message Default" + this.messageDefault;
	}
}
