package com.rapid.j2ee.framework.mvc.constants;

import org.springframework.util.Assert;

import com.rapid.j2ee.framework.core.utils.Constants;
import com.rapid.j2ee.framework.core.utils.StringUtils;

public enum ViewerType {

	Xml("xml", "xml", "text/xml", "xml", true), Json("json", "json",
			"application/json", "json", true), XmlZip("xmlzip", "xml",
			"application/x-zip-compressed", "zip", true), text("text", "text",
			"text/plain", "txt", true), TextZip("textzip", "text",
			"application/x-zip-compressed", "zip", true), Stream("stream",
			"stream", "application/octet-stream", "zip", true), Html("html",
			"html", "text/html", "xml", false), ByRequest("mode", "mode",
			"mode", "mode", true);

	private String viewType;

	private String innerType;

	private String contentType;

	private String extension;

	private boolean writeResponse;

	private ViewerType(String viewType, String innerType, String contentType,
			String extension, boolean writeResponse) {
		this.viewType = viewType;
		this.innerType = innerType;
		this.contentType = contentType;
		this.extension = extension;
		this.writeResponse = writeResponse;
	}

	public String getContentType() {
		return contentType;
	}

	public String getExtension() {
		return extension;
	}

	public String getInnerType() {
		return innerType;
	}

	public String getViewType() {
		return viewType;
	}

	public boolean isZip() {
		return "application/x-zip-compressed".equalsIgnoreCase(this
				.getContentType());
	}

	public boolean isWriteResponse() {
		return writeResponse;
	}

	private static Constants<ViewerType> ViewerType_Constants = new Constants<ViewerType>(
			ViewerType.class, true);

	public static ViewerType getViewerType(String viewType) {

		ViewerType type = ViewerType_Constants.asObjectByFieldName("viewType",
				StringUtils.trimToEmpty(viewType).toLowerCase());

		Assert.notNull(type, "Please provide a legal view type! [" + viewType
				+ "]");
		return type;
	}

}
