package com.rapid.j2ee.framework.mvc.i18n;

import com.rapid.j2ee.framework.core.utils.ObjectUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public abstract class AbstractI18NMessageFormat implements I18NMessageFormat {

	public String format(String[] messageCodes, String defMessage,
			Object[] arguments) {

		for (String messageCode : messageCodes) {

			String message = format(messageCode, null, arguments);

			if (!TypeChecker.isEmpty(message)
					&& !StringUtils.equals(defMessage, message)) {
				return message;
			}
		}

		return defMessage;

	}

	public String format(String messageCode, String defMessage) {

		return StringUtils.trimToEmpty(this.format(messageCode, defMessage,
				ObjectUtils.EMPTY_OBJECT_ARRAYS), defMessage);
	}

	public String format(String messageCode) {

		return format(messageCode, "");
	}

}
