package com.rapid.j2ee.framework.mvc.i18n;

import java.util.Locale;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

import com.rapid.j2ee.framework.core.utils.StringUtils;

public class SpringContainerI18NMessageFormat extends AbstractI18NMessageFormat
		implements ApplicationContextAware {

	private final Log logger = LogFactory.getLog(this.getClass());

	public String format(String messageCode, String defMessage,
			Object[] arguments) {

		logger.info("messageCode = " + messageCode);

		logger.info("arguments = " + StringUtils.printArrays(arguments));

		try {
			String i18nMessage = applicationContext.getMessage(messageCode,
					arguments, Locale.CHINESE);

			return StringUtils.trimToEmpty(i18nMessage, defMessage);

		} catch (Exception e) {

			return defMessage;
		}

	}

	public void setApplicationContext(ApplicationContext applicationContext)
			throws BeansException {
		this.applicationContext = applicationContext;
	}

	private ApplicationContext applicationContext;

}
