package com.rapid.j2ee.framework.mvc.jvm;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import com.rapid.j2ee.framework.core.utils.NumberUtils;

public class JVMMemoryGarbageFilter implements Filter {

	public void destroy() {

	}

	public void doFilter(ServletRequest request, ServletResponse response,
			FilterChain chain) throws IOException, ServletException {

		if (getCurrentFreeMemoryRate() < gcStartByMinFreeMemoryRate) {

			Runtime.getRuntime().gc();
		}

		chain.doFilter(request, response);

	}

	public void init(FilterConfig filterConfig) throws ServletException {

		gcStartByMinFreeMemoryRate = NumberUtils.parseDouble(filterConfig
				.getInitParameter("GCMinFreeMemoryRate"), 25.0);

		jvmMemoryInform = new JVMMemoryInform();
		jvmMemoryInform.setGcStartFreeMemoryRate(String
				.valueOf(gcStartByMinFreeMemoryRate));

		filterConfig.getServletContext().setAttribute("JVMMemoryInform",
				jvmMemoryInform);

	}

	private double getCurrentFreeMemoryRate() {

		Runtime rt = Runtime.getRuntime();

		long totalMemory = rt.totalMemory();
		long freeMemory = rt.freeMemory();

		jvmMemoryInform.setFreeMemorySize((int) (freeMemory / 0x100000L));
		jvmMemoryInform.setTotalMemorySize((int) (totalMemory / 0x100000L));
		jvmMemoryInform.setRateFreeMemory(String.valueOf((freeMemory * 100.00)
				/ totalMemory)
				+ "%");

		return (freeMemory * 100.00) / totalMemory;
	}

	private double gcStartByMinFreeMemoryRate;

	private static JVMMemoryInform jvmMemoryInform;

}
