package com.rapid.j2ee.framework.mvc.security.algorithm;

import java.lang.reflect.Method;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.mvc.exception.NoPermissionAccessibleApplicationException;
import com.rapid.j2ee.framework.mvc.security.logic.MvcSecurityAuthority;
import com.rapid.j2ee.framework.mvc.security.utils.MvcSecurityActionContextUtils;
import com.rapid.j2ee.framework.mvc.security.version.MvcApplicationVersionVerfication;
import com.rapid.j2ee.framework.mvc.utils.ActionContextUtils;

public class MvcRequestAuthorityGeneralVerification implements
		MvcRequestAuthorityVerification, InitializingBean {

	public void doRequestAuthorityVerification(HttpServletRequest request,
			Object action, Method method) {

		if (!mvcRequestSessionInspection.isRequestSessionInspectable(request,
				action, method)) {

			if (!TypeChecker.isNull(batchJobWebUserInjectionBeforeLogin)) {

				ActionContextUtils.setBeforeLoginStage();

				Logger
						.info("Login for before login*********************************************************************************!!!");

				MvcSecurityActionContextUtils
						.setBatchJobWebUser(batchJobWebUserInjectionBeforeLogin
								.getBatchJobWebUser(action, method));
			}

			return;
		}

		mvcSecurityAuthority.doSecurityAuthorityVerifty(action, method);

		mvcRequestSessionInspection.inspect();

		if (!mvcRequestFunctionPointAcceptable.accept(request, action, method)) {

			throw new NoPermissionAccessibleApplicationException();
		}

		mvcApplicationVersionVerfication.checkApplicationVersion(request);

	}

	public void afterPropertiesSet() throws Exception {
		Assert.notNull(mvcSecurityAuthority,
				"Please provide a mvc security authority instance!");
	}

	public void setMvcRequestFunctionPointAcceptable(
			MvcRequestFunctionPointAcceptable mvcRequestFunctionPointAcceptable) {
		this.mvcRequestFunctionPointAcceptable = mvcRequestFunctionPointAcceptable;
	}

	public void setMvcRequestSessionInspection(
			MvcRequestSessionInspection mvcRequestSessionInspection) {
		this.mvcRequestSessionInspection = mvcRequestSessionInspection;
	}

	public void setMvcSecurityAuthority(
			MvcSecurityAuthority mvcSecurityAuthority) {
		this.mvcSecurityAuthority = mvcSecurityAuthority;
	}

	public void setMvcApplicationVersionVerfication(
			MvcApplicationVersionVerfication mvcApplicationVersionVerfication) {
		this.mvcApplicationVersionVerfication = mvcApplicationVersionVerfication;
	}

	private MvcSecurityAuthority mvcSecurityAuthority;

	private MvcRequestSessionInspection mvcRequestSessionInspection = MvcRequestSessionInspection.Default_Request_Session_Inspect;

	private MvcRequestFunctionPointAcceptable mvcRequestFunctionPointAcceptable = new MvcRequestFunctionPointUnlimitationAcceptable();

	private MvcApplicationVersionVerfication mvcApplicationVersionVerfication = MvcApplicationVersionVerfication.Default_No_ApplicationVersion_Verfication;

	@Autowired(required = false)
	private BatchJobWebUserInjectionBeforeLogin batchJobWebUserInjectionBeforeLogin;

	private static Log Logger = LogFactory
			.getLog(MvcRequestAuthorityGeneralVerification.class);

}
