package com.rapid.j2ee.framework.mvc.security.algorithm;

import java.lang.reflect.Method;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

import com.rapid.j2ee.framework.mvc.security.logic.MvcSecurityAuthority;
import com.rapid.j2ee.framework.mvc.security.version.MvcApplicationVersionVerfication;

public class MvcRequestSNAuthorityGeneralVerification implements
		MvcRequestAuthorityVerification, InitializingBean {

	public void doRequestAuthorityVerification(HttpServletRequest request,
			Object action, Method method) {

		mvcSecurityAuthority.doSecurityAuthorityVerifty(action, method);

		mvcApplicationVersionVerfication.checkApplicationVersion(request);

	}

	public void afterPropertiesSet() throws Exception {
		Assert.notNull(mvcSecurityAuthority,
				"Please provide a mvc security authority instance!");
	}

	public void setMvcSecurityAuthority(
			MvcSecurityAuthority mvcSecurityAuthority) {
		this.mvcSecurityAuthority = mvcSecurityAuthority;
	}

	public void setMvcApplicationVersionVerfication(
			MvcApplicationVersionVerfication mvcApplicationVersionVerfication) {
		this.mvcApplicationVersionVerfication = mvcApplicationVersionVerfication;
	}

	private MvcSecurityAuthority mvcSecurityAuthority;

	private MvcApplicationVersionVerfication mvcApplicationVersionVerfication = MvcApplicationVersionVerfication.Default_No_ApplicationVersion_Verfication;

}
