package com.rapid.j2ee.framework.mvc.security.algorithm;

import java.lang.reflect.Method;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.mvc.exception.SessionTimeoutApplicationException;
import com.rapid.j2ee.framework.mvc.security.utils.MvcSecurityActionContextUtils;

public class MvcRequestSessionGeneralInspection implements
		MvcRequestSessionInspection {

	public MvcRequestSessionGeneralInspection() {

	}

	public boolean isRequestSessionInspectable(HttpServletRequest request,
			Object action, Method method) {

		if (this.isSessionUnInspectForMethod(action, method)) {
			return false;
		}

		if (this.isSessionUnInspectForUrl(request.getRequestURI() + "?"
				+ request.getQueryString())) {
			return false;
		}

		return true;
	}

	public void inspect() {

		if (!MvcSecurityActionContextUtils.isLoginState()) {
			throw new SessionTimeoutApplicationException();
		}
	}

	private boolean isSessionUnInspectForMethod(Object action, Method method) {

		logger.info("Session Inspected Action.Name: "
				+ action.getClass().getName() + "." + method.getName());

		logger.info("Session Inspected Before Action Methods: "
				+ beforeLoginActionMethods);

		if (TypeChecker.isEmpty(this.beforeLoginActionMethods)) {
			return false;
		}

		return beforeLoginActionMethods.contains(action.getClass().getName()
				+ "." + method.getName());

	}

	private boolean isSessionUnInspectForUrl(String url) {

		if (TypeChecker.isEmpty(this.beforeLoginNamespaceUrls)) {
			return false;
		}

		logger.info("Session Uninspected Url: " + url);

		logger.info("Session Uninspected Before Login namespace Urls: "
				+ beforeLoginNamespaceUrls);

		for (String namespace : beforeLoginNamespaceUrls) {

			if (StringUtils.match(url, namespace)) {

				logger.info("Session Uninspected Url Namespace: " + namespace);

				return true;
			}
		}

		return false;

	}

	public void setBeforeLoginActionMethods(
			List<String> beforeLoginActionMethods) {
		this.beforeLoginActionMethods = beforeLoginActionMethods;
	}

	public void setBeforeLoginNamespaceUrls(
			List<String> beforeLoginNamespaceUrls) {
		this.beforeLoginNamespaceUrls = beforeLoginNamespaceUrls;
	}

	private List<String> beforeLoginActionMethods;

	private List<String> beforeLoginNamespaceUrls;

	private Log logger = LogFactory.getLog(this.getClass());

	public static void main(String[] args) {
		System.out.println(StringUtils
				.match("/login_protable/", "*/protable/*"));
	}

}
