package com.rapid.j2ee.framework.mvc.security.logger.listener;

import org.springframework.context.ApplicationContext;

import com.rapid.j2ee.framework.core.spring.AsynchronousApplicationListener;
import com.rapid.j2ee.framework.mvc.security.domain.WebUser;
import com.rapid.j2ee.framework.mvc.security.logger.AuditActionLogger;
import com.rapid.j2ee.framework.mvc.security.utils.MvcSecurityActionContextUtils;

public abstract class AbstractAsynAuditActionLoggerKeepReceiver extends
		AsynchronousApplicationListener<AuditActionLoggerApplicationEvent> {

	@Override
	protected void doHandleApplicationEvent(
			AuditActionLoggerApplicationEvent event) {

		try {

			MvcSecurityActionContextUtils
					.setBatchJobWebUser(event.getWebUser());
			
			this.saveAuditActionLogger(event.getApplicationContext(), event
					.getAuditActionLogger(), event.getWebUser());

		} catch (Throwable e) {
			e.printStackTrace();
		}
	}

	protected abstract void saveAuditActionLogger(
			ApplicationContext applicationContext,
			AuditActionLogger auditActionLogger, WebUser webUser);
}
