package com.rapid.j2ee.framework.mvc.security.logic;

import java.lang.reflect.Method;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.rapid.j2ee.framework.core.cryptology.CryptologyFactory;
import com.rapid.j2ee.framework.core.cryptology.CryptologyType;
import com.rapid.j2ee.framework.core.exception.ApplicationException;
import com.rapid.j2ee.framework.core.utils.RequestUtils;
import com.rapid.j2ee.framework.core.utils.StatusTypes;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.mvc.constants.OperationResult;
import com.rapid.j2ee.framework.mvc.constants.OperationResultConstants;
import com.rapid.j2ee.framework.mvc.utils.ActionContextUtils;

public abstract class AbstractRequestCertificationSNSecurityAuthority implements
		MvcSecurityAuthority {

	public void doSecurityAuthorityVerifty(Object action, Method methodObject) {

		if (!isSecuritySNValidation()) {
			throw new ApplicationException(
					OperationResultConstants.FAILED_SECURITY_SN_LOST);
		}

		String sn = getParameterValue(parameterSecurityKeyName);

		String applicationName = getParameterValue(parameterApplicationName);

		String saltWeightValues = getSaltWeightValues();

		String hashCode = getParameterValue(parameterHashcodeName);

		String salt = this.getSecuritySaltByApplicationName(applicationName);

		String backendHashcode = this.getCalcBackendHashCode(saltWeightValues,
				applicationName, sn, salt, hashCode);

		if (this.isNewRequestCertificationSN(applicationName, sn)) {

			if (StringUtils.equals(backendHashcode, hashCode)) {

				this.saveRequestCertificationSNLog(StatusTypes.Active,
						applicationName, saltWeightValues, salt, sn, hashCode,
						backendHashcode);

				return;

			}

			this.saveRequestCertificationSNLog(StatusTypes.Error,
					applicationName, saltWeightValues, salt, sn, hashCode,
					backendHashcode);

			throwCertificationException(OperationResultConstants.FAILED_SECURITY_SN_ERROR);

			return;

		}

		throwCertificationException(OperationResultConstants.FAILED_SECURITY_SN_EXPIRED);

	}

	private void throwCertificationException(OperationResult operationResult) {

		if (this.ignoreSNAuthorityBoolean) {
			return;
		}

		throw new ApplicationException(operationResult);
	}

	protected abstract boolean isNewRequestCertificationSN(
			String applicationName, String sn);

	protected abstract void saveRequestCertificationSNLog(StatusTypes type,
			String applicationName, String saltWeightValues, String salt,
			String sn, String hashcode, String backendHashcode);

	private String getCalcBackendHashCode(String method,
			String applicationName, String sn, String salt,
			String requestHashcode) {

		String backendCalcHashcode = CryptologyFactory.getSingleCryptology(
				CryptologyType.Md5).encrypt(
				sn + applicationName + method + salt);

		if (debugBoolean) {
			log
					.info("The Calculated Hashcode of Backend [sn + applicationName + method + salt]:"
							+ backendCalcHashcode
							+ " Request Hashcode:"
							+ requestHashcode);
		}

		return backendCalcHashcode;
	}

	private String getSaltWeightValues() {

		String slatWeightValue = "";

		for (String name : StringUtils.splitBySeparators(
				this.parameterSaltWeightNames, ",", ";")) {

			slatWeightValue += ActionContextUtils.getHttpParameter(name);
		}

		return slatWeightValue;

	}

	public static String getSecuritySaltByApplicationName(String applicationName) {

		if (TypeChecker.isEmpty(applicationName)) {
			return "";
		}

		applicationName = applicationName.toUpperCase();

		StringBuffer salt = new StringBuffer(applicationName.length());

		for (int i = 0, j = applicationName.length(); i < j; i++) {
			salt.append((char) ((int) applicationName.charAt(i) + (i / 6 + i
					/ 5 + i / 4 + i / 3 + i / 2 + i + 1)));
		}

		String saltValue = "[" + salt.toString() + "]";

		if (debugBoolean) {
			System.out.println("SN Salt:" + saltValue);
		}

		return saltValue;
	}

	private boolean isSecuritySNValidation() {

		return !TypeChecker
				.isEmpty(getParameterValue(parameterSecurityKeyName))
				&& !TypeChecker
						.isEmpty(getParameterValue(parameterHashcodeName))
				&& !TypeChecker
						.isEmpty(getParameterValue(this.parameterApplicationName));
	}

	protected String getParameterValue(String name) {

		String value = ActionContextUtils.getHttpParameter(name);

		if (!TypeChecker.isNull(value)) {
			return value;
		}

		return ActionContextUtils.getRequestHeader(name);
	}

	public void setParameterApplicationName(String parameterApplicationName) {
		this.parameterApplicationName = parameterApplicationName;
	}

	public void setParameterHashcodeName(String parameterHashcodeName) {
		this.parameterHashcodeName = parameterHashcodeName;
	}

	public void setParameterSecurityKeyName(String parameterSecurityKeyName) {
		this.parameterSecurityKeyName = parameterSecurityKeyName;
	}

	public void setDebug(String debug) {

		debugBoolean = TypeChecker.isSpecialTrue(debug);
	}

	public void setParameterSaltWeightNames(String parameterSaltWeightNames) {
		this.parameterSaltWeightNames = parameterSaltWeightNames;
	}

	public void setIgnoreSNAuthority(String escapeSn) {
		ignoreSNAuthorityBoolean = TypeChecker.isSpecialTrue(escapeSn);
	}

	private String parameterSecurityKeyName = "sn";

	private String parameterHashcodeName = "hashCode";

	private String parameterApplicationName = "applicationName";

	private String parameterSaltWeightNames = "method";

	private static boolean debugBoolean = false;

	private boolean ignoreSNAuthorityBoolean = false;

	protected Log log = LogFactory.getLog(this.getClass());

}
