package com.rapid.j2ee.framework.mvc.security.logic;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.opensymphony.xwork2.ActionInvocation;
import com.rapid.j2ee.framework.mvc.security.MvcSecurityCleanUpInterceptor;

public class MvcSecurityCleanUpInterceptorHandler {

	public MvcSecurityCleanUpInterceptorHandler() {

	}

	public void start(ActionInvocation actionInvocation, String method) {

		if (this.actionCount.get() == 0) {

			for (MvcSecurityCleanUpInterceptor mvcSecurityCleanUpInterceptor : mvcSecurityCleanUpInterceptors) {
				mvcSecurityCleanUpInterceptor.start(actionInvocation, method);
			}
		}

		this.actionCount.set(this.actionCount.get() + 1);
	}

	public void end(ActionInvocation actionInvocation, String method) {
		this.actionCount.set(actionCount.get() - 1);

		if (this.actionCount.get() <= 0) {
			for (MvcSecurityCleanUpInterceptor mvcSecurityCleanUpInterceptor : mvcSecurityCleanUpInterceptors) {
				mvcSecurityCleanUpInterceptor.end(actionInvocation, method);
			}
		}
	}

	public static final MvcSecurityCleanUpInterceptorHandler Default_Do_Nothing = new MvcSecurityCleanUpInterceptorHandler();

	@Autowired(required = false)
	private List<MvcSecurityCleanUpInterceptor> mvcSecurityCleanUpInterceptors = new ArrayList<MvcSecurityCleanUpInterceptor>();

	private ThreadLocal<Integer> actionCount = new ThreadLocal<Integer>() {
		@Override
		protected Integer initialValue() {

			return 0;
		}
	};
}
