package com.rapid.j2ee.framework.mvc.security.logic;

import java.lang.reflect.Method;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

import com.rapid.j2ee.framework.core.spring.SpringApplicationContextHolder;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.mvc.security.domain.WebUser;
import com.rapid.j2ee.framework.mvc.security.utils.MvcSecurityActionContextUtils;
import com.rapid.j2ee.framework.mvc.utils.ActionContextUtils;

public abstract class UserLoginMvcSecurityAuthority implements
		MvcSecurityAuthority, InitializingBean {

	public void doSecurityAuthorityVerifty(Object action, Method method) {

		this.doVerificationCodeSecurityAuthority(action, method);

		WebUser webUser = this.login(ActionContextUtils
				.getHttpParameter(this.parameterUserIdName), ActionContextUtils
				.getHttpParameter(this.parameterPasswordName),
				ActionContextUtils
						.getHttpParameter(this.parameterPlatformIdName));

		webUser = userLoginMvcSecurityResolver.resolve(webUser);

		MvcSecurityActionContextUtils.setWebUser(webUser, this
				.isWebSessionMandatory());

	}

	private void doVerificationCodeSecurityAuthority(Object action,
			Method method) {

		if (this.isVerificationCodeSecurityIgnorable(action, method)) {
			return;
		}

		verificationCodeSecurityAuthority.doSecurityAuthorityVerifty(action,
				method);
	}

	protected abstract boolean isVerificationCodeSecurityIgnorable(
			Object action, Method method);

	protected abstract boolean isWebSessionMandatory();

	protected abstract WebUser login(String userId, String password,
			String platformId);

	public boolean isSecurityVerficationRequired() {

		return !TypeChecker.isEmpty(ActionContextUtils
				.getHttpParameter(this.parameterUserIdName))
				&& !TypeChecker.isEmpty(ActionContextUtils
						.getHttpParameter(this.parameterPasswordName));
	}

	public void setParameterPlatformIdName(String parameterPlatformIdName) {
		this.parameterPlatformIdName = parameterPlatformIdName;
	}

	public void setParameterPasswordName(String parameterPasswordName) {
		this.parameterPasswordName = parameterPasswordName;
	}

	public void setParameterUserIdName(String parameterUserIdName) {
		this.parameterUserIdName = parameterUserIdName;
	}

	public void setUserLoginMvcSecurityResolverName(
			String userLoginMvcSecurityResolverName) {
		this.userLoginMvcSecurityResolverName = userLoginMvcSecurityResolverName;
	}

	public void afterPropertiesSet() throws Exception {

		if (TypeChecker.isEmpty(userLoginMvcSecurityResolverName)) {
			return;
		}

		userLoginMvcSecurityResolver = (UserLoginMvcSecurityResolver) SpringApplicationContextHolder
				.getBean(userLoginMvcSecurityResolverName);
	}

	public void setVerificationCodeSecurityAuthority(
			VerificationCodeSecurityAuthority verificationCodeSecurityAuthority) {
		this.verificationCodeSecurityAuthority = verificationCodeSecurityAuthority;
	}

	private String parameterUserIdName = "userId";

	private String parameterPasswordName = "password";

	private String parameterPlatformIdName = "platformId";

	private String userLoginMvcSecurityResolverName = "";

	private UserLoginMvcSecurityResolver userLoginMvcSecurityResolver = UserLoginMvcSecurityResolver.UserLoginMvcSecurityResolver_Instance;

	private VerificationCodeSecurityAuthority verificationCodeSecurityAuthority = VerificationCodeSecurityAuthority.VerificationCode_Unstrict_SecurityAuthority;

}
