package com.rapid.j2ee.framework.mvc.security.logic;

import com.rapid.j2ee.framework.mvc.security.domain.WebUserTokenSession;

public interface UserTokenContainerManagerOAuth2 {

	public void registry();

	public void logout(String tokenId);

	public boolean doTokenEligibilityValidate();

	public void printTokenSessionMap();

	public WebUserTokenSession renewTokenId();

	/**
	 * 使用code换取access_token
	 * 
	 * @param Auth
	 *            Code -- 第一步获取的code参数
	 * @param Client
	 *            Id -- 公众号的唯一标识
	 * @param client
	 *            Pwd -- 公众号的Pwd
	 * 
	 * @return Token Id
	 */
	public WebUserTokenSession getWebUserTokenSessionByAuthorityCode();

	public String decodePlatformIdByRefreshTokenId(String refreshTokenId);

}
