package com.rapid.j2ee.framework.mvc.security.logic;

import java.lang.reflect.Method;

import com.rapid.j2ee.framework.core.exception.StreamReaderObjectParseSystemException;
import com.rapid.j2ee.framework.mvc.exception.SessionTimeoutApplicationException;

public class UserTokenMvcSecurityAuthority implements MvcSecurityAuthority {

	public void doSecurityAuthorityVerifty(Object action, Method method) {

		try {

			// Pass user id and password in http request
			if (userLoginMvcSecurityAuthority.isSecurityVerficationRequired()) {
				// Login
				userLoginMvcSecurityAuthority.doSecurityAuthorityVerifty(
						action, method);
				// Save Token to Memory and Database
				userTokenContainerManager.registry();

				return;
			}

			if (!userTokenContainerManager.doTokenEligibilityValidate()) {
				throw new SessionTimeoutApplicationException();
			}

		} catch (StreamReaderObjectParseSystemException streamReaderObjectParseSystemException) {
			throw new SessionTimeoutApplicationException();
		} finally {
			this.userTokenContainerManager.printTokenSessionMap();
		}

	}

	public void setUserLoginMvcSecurityAuthority(
			UserLoginMvcSecurityAuthority userLoginMvcSecurityAuthority) {
		this.userLoginMvcSecurityAuthority = userLoginMvcSecurityAuthority;
	}

	public void setUserTokenContainerManager(
			UserTokenContainerManager userTokenContainerManager) {
		this.userTokenContainerManager = userTokenContainerManager;
	}

	private UserLoginMvcSecurityAuthority userLoginMvcSecurityAuthority;

	private UserTokenContainerManagerOAuth2 userTokenContainerManager;

}
