package com.rapid.j2ee.framework.mvc.security.logic;

import java.lang.reflect.Method;

import com.rapid.j2ee.framework.core.exception.ApplicationException;
import com.rapid.j2ee.framework.core.utils.RequestUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.core.utils.verificationcode.VerificationImageCodeUtils;
import com.rapid.j2ee.framework.core.utils.verificationcode.VerificationSMSCodeUtils;
import com.rapid.j2ee.framework.mvc.constants.OperationResultConstants;

import com.rapid.j2ee.framework.mvc.utils.ActionContextUtils;

public class VerificationCodeSecurityAuthority implements MvcSecurityAuthority {

	public void doSecurityAuthorityVerifty(Object action, Method method) {

		if (this.isVerificationCodeCheckIgnorable()) {
			return;
		}

		if (isVerificationCodeValidByCompareHashCodeAsHttpParameter()) {
			return;
		}

		if (VerificationImageCodeUtils
				.isVerificationImageCodeValidByCookie(ActionContextUtils
						.getHttpParameter(this.parameterVerificationCodeName))) {
			return;
		}

		if (VerificationSMSCodeUtils.isVerificationCodeValidByCookie(
				getMobileNumber(), ActionContextUtils
						.getHttpParameter(this.parameterVerificationCodeName))) {

			return;
		}

		if (sessionStorage) {

			if (StringUtils.equalsIgnoreCase(ActionContextUtils
					.getHttpParameter(this.parameterVerificationCodeName),
					(String) RequestUtils.getHttpSession(
							ActionContextUtils.getHttpRequest()).getAttribute(
							VerificationSMSCodeUtils.class.getSimpleName()))) {

				return;
			}

			if (StringUtils.equalsIgnoreCase(ActionContextUtils
					.getHttpParameter(this.parameterVerificationCodeName),
					(String) RequestUtils.getHttpSession(
							ActionContextUtils.getHttpRequest()).getAttribute(
							VerificationImageCodeUtils.class.getSimpleName()))) {
				return;
			}

		}

		throw new ApplicationException(
				OperationResultConstants.FAILED_VERIFICATION_CODE_ERROR);
	}

	private boolean isVerificationCodeValidByCompareHashCodeAsHttpParameter() {

		String verificationHashcode = ActionContextUtils
				.getHttpParameter(parameterVerificationHashcodeName);

		String verificationCode = ActionContextUtils
				.getHttpParameter(this.parameterVerificationCodeName);

		if (TypeChecker.isEmpty(verificationHashcode)) {
			return false;
		}

		return VerificationImageCodeUtils.isVerificationImageCodeValid(
				verificationCode, verificationHashcode)
				|| VerificationSMSCodeUtils.isVerificationHashcodeValid(
						getMobileNumber(), verificationCode,
						verificationHashcode);
	}

	private boolean isVerificationCodeCheckIgnorable() {

		String platformId = ActionContextUtils
				.getHttpParameter(parameterPlatformIdName);

		if (TypeChecker.isEmpty(platformId)) {
			return false;
		}

		return StringUtils.containsIgnoreCase(ignoreVerificationPlatformIds,
				platformId,
				VerificationSMSCodeUtils.VerificationCode_Multiple_Separator);
	}

	public void setParameterPlatformIdName(String parameterPlatformIdName) {
		this.parameterPlatformIdName = parameterPlatformIdName;
	}

	public void setIgnoreVerificationPlatformIds(
			String ignoreVerificationPlatformIds) {
		this.ignoreVerificationPlatformIds = ignoreVerificationPlatformIds;
	}

	public void setParameterVerificationCodeName(
			String parameterVerificationCodeName) {
		this.parameterVerificationCodeName = parameterVerificationCodeName;
	}

	public void setParameterVerificationHashcodeName(
			String parameterVerificationHashcodeName) {
		this.parameterVerificationHashcodeName = parameterVerificationHashcodeName;
	}

	public void setParameterMobileNumberNames(
			String[] parameterMobileNumberNames) {
		this.parameterMobileNumberNames = parameterMobileNumberNames;
	}

	public void setSessionStorageOpen(boolean sessionStorage) {
		this.sessionStorage = sessionStorage;
	}

	private String getMobileNumber() {

		for (String mobileNoParameter : parameterMobileNumberNames) {
			String mobileNo = ActionContextUtils
					.getHttpParameter(mobileNoParameter);
			if (!TypeChecker.isEmpty(mobileNo)) {
				return mobileNo;
			}
		}

		return "";
	}

	private String parameterPlatformIdName = "platformId";

	private String[] parameterMobileNumberNames = new String[] { "userId" };

	private String parameterVerificationCodeName = "verificationCode";

	private String parameterVerificationHashcodeName = "verificationHashcode";

	private String ignoreVerificationPlatformIds = "ignoreVerificationPlatformIds";

	private boolean sessionStorage = true;

	public static final VerificationCodeSecurityAuthority VerificationCode_Unstrict_SecurityAuthority = new VerificationCodeSecurityAuthority() {
		@Override
		public void doSecurityAuthorityVerifty(Object action, Method method) {

		}
	};

}
