package com.rapid.j2ee.framework.mvc.security.menu;

import com.rapid.j2ee.framework.core.utils.TypeChecker;

public abstract class AbstractMenuComponent implements MenuComponent,
		MenuComponentWritable, MenuComponentSourceTarget, MenuConstants,
		Comparable<AbstractMenuComponent> {

	private static final long serialVersionUID = 1L;

	protected String menuId;

	protected String menuPaths;

	protected String menuName;

	protected String menuUrl;

	protected String parentId;

	protected boolean leaf;

	private Object source;

	private String visitMode;

	private Double menuSeqNo;

	public AbstractMenuComponent(
			MenuComponentInitialized menuComponentInitialized,
			MenuSourceType source) {

		menuComponentInitialized.initialize(this, source);

		this.source = source;
	}

	public Double getMenuSeqNo() {
		return menuSeqNo;
	}

	public void setMenuSeqNo(Double menuSeqNo) {
		this.menuSeqNo = menuSeqNo;
	}

	public String getVisitMode() {
		return visitMode;
	}

	public void setSource(Object source) {
		this.source = source;

	}

	public Object getSource() {
		return this.source;
	}

	public boolean hasSourceTarget() {
		return TypeChecker.isNull(source);
	}

	public String toString() {
		return "MenuId:" + menuId + "Menu Name:" + menuName + "Leaf:"
				+ this.leaf + " Menu Paths:" + this.menuPaths + "\r\n";
	}

	public String getMenuId() {
		return menuId;
	}

	public String getMenuPaths() {
		return this.menuPaths;
	}

	public String getMenuName() {
		return menuName;
	}

	public String getMenuUrl() {

		if (TypeChecker.isEmpty(menuUrl)) {
			return menuUrl;
		}

		if (menuUrl.indexOf("?") < 0) {
			return this.menuUrl + "?" + Menu_Parameter_Name + "=" + this.menuId
					+ "&" + Menu_Access_Parameter_Name + "=Y";
		}

		return menuUrl + "&" + Menu_Parameter_Name + "=" + this.menuId + "&"
				+ Menu_Access_Parameter_Name + "=Y";
	}

	public String getParentId() {
		return parentId;
	}

	public void setLeaf(boolean leaf) {
		this.leaf = leaf;
	}

	public void setMenuId(String menuId) {
		this.menuId = menuId;
	}

	public void setMenuName(String menuName) {
		this.menuName = menuName;
	}

	public void setMenuPaths(String menuPaths) {
		this.menuPaths = menuPaths;
	}

	public void setMenuUrl(String menuUrl) {
		this.menuUrl = menuUrl;
	}

	public void setParentId(String parentId) {
		this.parentId = parentId;
	}

	public void setVisitMode(String visitMode) {
		this.visitMode = visitMode;
	}

	public int compareTo(AbstractMenuComponent abstractMenuComponent) {

		if (source instanceof Comparable) {
			return ((Comparable) source).compareTo(abstractMenuComponent
					.getSource());
		}

		if (TypeChecker.isNull(menuSeqNo)
				|| abstractMenuComponent.getMenuSeqNo() == null) {
			return 0;
		}
		


		if (Math.abs(abstractMenuComponent.getMenuSeqNo() - this.menuSeqNo) < 0.00000000000000000001) {
			return 0;
		}

		return abstractMenuComponent.getMenuSeqNo() - getMenuSeqNo() >= 0 ? 1
				: -1;
	}
}
