package com.rapid.j2ee.framework.mvc.security.menu;

import java.util.ArrayList;
import java.util.List;

import com.rapid.j2ee.framework.core.utils.TypeChecker;

public class MenuBranch extends AbstractMenuComponent {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private List<MenuComponent> menuComponents;

	public MenuBranch(MenuComponentInitialized menuComponentInitialized,
			MenuSourceType source) {
		super(menuComponentInitialized, source);
		menuComponents = new ArrayList<MenuComponent>(5);
	}

	public void add(MenuComponent component) {

		menuComponents.add(component);
	}

	public MenuComponent getComponent() {

		return this;
	}

	public List<MenuComponent> getComponents() {

		return menuComponents;
	}

	public boolean isLeaf() {

		return false;
	}

	public boolean isEmpty() {

		return TypeChecker.isEmpty(this.menuComponents);
	}

}
