package com.rapid.j2ee.framework.mvc.security.menu;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.opensymphony.xwork2.interceptor.NoParameters;
import com.rapid.j2ee.framework.core.utils.RequestUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public class MenuClickStorageInformationSessionInterceptor extends
		AbstractInterceptor {

	@Override
	public String intercept(ActionInvocation actionInvocation) throws Exception {

		Object action = actionInvocation.getAction();

		if (action instanceof NoParameters) {

			return actionInvocation.invoke();

		}

		ActionContext context = actionInvocation.getInvocationContext();

		HttpServletRequest request = (HttpServletRequest) context
				.get(ServletActionContext.HTTP_REQUEST);

		if (!this.isMenuAccess(request)) {
			return actionInvocation.invoke();
		}

		this.removeLastMenuSessionInformations(request.getSession());

		if (!this.isInformationSessionStorage(request)) {
			return actionInvocation.invoke();
		}

		Log.info("Menu Session Request Keys ======== "
				+ request.getParameter(this.menuSessionStorageRequestName));

		HttpSession session = RequestUtils.getHttpSession(request);

		session.setAttribute(menuSessionStorageRequestName, request
				.getParameter(menuSessionStorageRequestName));

		for (String sessionKey : StringUtils.splitBySeparator(request
				.getParameter(menuSessionStorageRequestName),
				Session_Information_RequestName_Separator)) {

			this.storeInformationSession(request, session, sessionKey);
		}

		return actionInvocation.invoke();
	}

	private void removeLastMenuSessionInformations(HttpSession session) {
		if (TypeChecker.isNull(session)) {
			return;
		}

		String sessionStorageNames = (String) session
				.getAttribute(menuSessionStorageRequestName);

		if (TypeChecker.isEmpty(sessionStorageNames)) {
			return;
		}

		for (String sessionKey : StringUtils.splitBySeparator(
				sessionStorageNames, Session_Information_RequestName_Separator)) {

			session.removeAttribute(sessionKey);
		}

	}

	private boolean isMenuAccess(HttpServletRequest request) {

		return TypeChecker.isSpecialTrue(request
				.getParameter(menuAccessRequestName));
	}

	private boolean isInformationSessionStorage(HttpServletRequest request) {

		return !TypeChecker.isEmpty(request
				.getParameter(menuSessionStorageRequestName));
	}

	private void storeInformationSession(HttpServletRequest request,
			HttpSession session, String sessionKey) {

		if (TypeChecker.isEmpty(sessionKey)) {
			return;
		}

		session.setAttribute(sessionKey, request.getParameter(sessionKey));
	}

	public void setMenuAccessRequestName(String menuAccessRequestName) {
		this.menuAccessRequestName = menuAccessRequestName;
	}

	public void setMenuSessionStorageRequestName(
			String menuSessionStorageRequestName) {
		this.menuSessionStorageRequestName = menuSessionStorageRequestName;
	}

	private String menuAccessRequestName = Menu_Click_RequestName;

	private String menuSessionStorageRequestName = Session_Information_Storage_RequestName;

	private static final String Session_Information_Storage_RequestName = "sessionNames";

	private static final String Session_Information_RequestName_Separator = ",";

	private static final String Menu_Click_RequestName = "menuAccess";

	private static final long serialVersionUID = 1L;

	private static Log Log = LogFactory
			.getLog(MenuClickStorageInformationSessionInterceptor.class);

}
