package com.rapid.j2ee.framework.mvc.security.menu;

import com.rapid.j2ee.framework.core.utils.Constants;

public interface MenuConstants {

	public static final String Menu_BeforeLogin_Storage_ApplicationKey = "RESOURCE_MENU_BEFORELOGIN_RESOUCES_APPLICATION_KEY";

	public static final String Menu_AfterLogin_Storage_ApplicationKey = "RESOURCE_MENU_AFTERLOGIN_RESOUCES_APPLICATION_KEY";

	public static final String Menu_Type_Branch = "B";

	public static final String Menu_Type_Leaf = "L";

	public static final String Menu_Path_Separator = ",";

	public static final String Menu_Root_ID = "root";

	public static final String Menu_Parameter_Name = "menuId";

	public static final String Menu_Access_Parameter_Name = "menuAccess";

	public static final int Menu_SeqNo_Step = 2000;

	public static enum MenuMovement {

		Up(Menu_SeqNo_Step * -1), Down(Menu_SeqNo_Step);

		private int step;

		private MenuMovement(int step) {
			this.step = step;
		}

		private static final Constants<MenuMovement> MenuMovement_Constants = new Constants<MenuMovement>(
				MenuMovement.class);

		public static MenuMovement getMenuMovementByType(String type) {
			return MenuMovement_Constants.asObject(type);
		}

		public int getStep() {
			return step;
		}
	};

}
