package com.rapid.j2ee.framework.mvc.security.menu;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.rapid.j2ee.framework.core.utils.ObjectUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.mvc.security.domain.WebUser;
import com.rapid.j2ee.framework.mvc.security.utils.MvcSecurityActionContextUtils;

public class MenuTree implements java.io.Serializable {

	private Map<String, MenuComponent> menuItemContainers = ObjectUtils.EMPTY_MAP;

	private transient MenuTreeActionListener menuTreeActionListener = MenuTreeActionListener.Do_Nothing_MenuTreeAction_Listener;

	private MenuComponentInitialized menuComponentInitialized;

	private MenuComponent rootMenu = null;

	public MenuTree(MenuComponentInitialized menuComponentInitialized,
			MenuSourceType rootSource) {

		this.menuComponentInitialized = menuComponentInitialized;

		rootMenu = new MenuBranch(menuComponentInitialized, rootSource);

	}

	public void addMenuTreeActionListener(
			MenuTreeActionListener menuTreeActionListener) {

		this.menuTreeActionListener = menuTreeActionListener;
	}

	public MenuTree addMenuSources(List<? extends MenuSourceType> sources) {
		return addMenuSources(MvcSecurityActionContextUtils.getWebUser(),
				sources);
	}

	public MenuTree addMenuSources(WebUser user,
			List<? extends MenuSourceType> sources) {

		if (TypeChecker.isEmpty(sources)) {
			return this;
		}

		menuItemContainers = new HashMap<String, MenuComponent>(sources.size());

		for (MenuSourceType source : sources) {

			MenuComponent component = (source.isLeaf() ? new MenuLeaf(
					menuComponentInitialized, source) : new MenuBranch(
					menuComponentInitialized, source));

			if (menuTreeActionListener.acceptable(user, component, source)) {

				menuTreeActionListener.performByAddMenuResource(user,
						component, source);

				menuItemContainers.put(component.getMenuId(), component);

				addMenuComponent(component);
			}

		}

		return this;
	}

	public void addMenuComponent(MenuComponent node) {
		_addMenuComponent(rootMenu, node);
	}

	private void _addMenuComponent(MenuComponent root, MenuComponent node) {

		if (root.getMenuId().equalsIgnoreCase(node.getParentId())) {

			((MenuComponentWritable) root).add(node);

			Collections.sort((List) ((MenuComponent) root).getComponents());

			return;
		}

		for (MenuComponent n : root.getComponents()) {
			_addMenuComponent(n, node);
		}

	}

	public MenuComponent getRoot() {
		return this.rootMenu;
	}

	public boolean isEmptyTree() {
		return TypeChecker.isEmpty(getRoot().getComponents());
	}

	public MenuComponent findByMenuId(String menuId) {

		return menuItemContainers.get(menuId);
	}

	public boolean contain(String menuId) {
		return this.menuItemContainers.containsKey(menuId);
	}

	public String getMenuNavigation(String menuId) {
		return getMenuNavigation(findByMenuId(menuId));
	}

	public String getMenuNavigation(MenuComponent menu) {

		String[] menuIds = StringUtils.splitBySeparators(menu.getMenuPaths(),
				MenuConstants.Menu_Path_Separator, ":", ";");

		if (TypeChecker.isEmpty(menuIds) || menuIds.length == 1) {
			return "";
		}

		List<String> items = new ArrayList<String>();

		for (String menuId : menuIds) {

			if (!contain(menuId)) {
				continue;
			}

			items.add(findByMenuId(menuId).getMenuName());
		}

		if (items.size() == 1) {
			return items.get(0);
		}

		String lastMenuName = items.remove(items.size() - 1);

		return StringUtils.getStringBunch(items, " &gt; ") + " &gt; "
				+ lastMenuName;
	}

	public List getMenuComponentSources() {
		return _getMenuComponentSources(this.rootMenu);
	}

	private List _getMenuComponentSources(MenuComponent menu) {

		List menuComponents = new ArrayList();

		if (TypeChecker.isNull(menu)) {

			return menuComponents;
		}

		if (MenuConstants.Menu_Root_ID.equalsIgnoreCase(menu.getMenuId())) {
			// 根节点
			// 没有 Root 节点

		}

		if (TypeChecker.isEmpty(menu.getComponents())) {
			return menuComponents;
		}

		for (MenuComponent menuTemp : menu.getComponents()) {

			menuComponents.add(menuTemp.getSource());

			menuComponents.addAll(_getMenuComponentSources(menuTemp));

		}

		return menuComponents;

	}

	private static final long serialVersionUID = 1L;

}
