package com.rapid.j2ee.framework.mvc.security.passsword;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

import com.rapid.j2ee.framework.core.utils.CollectionsUtil;
import com.rapid.j2ee.framework.core.utils.ObjectUtils;

public class MvcSecurityPasswordEncodeFactory implements InitializingBean {

	public String encrypt(String sourceId, String pwd) {

		return this.getMvcSecurityPasswordEncode(sourceId).encrypt(pwd);

	}

	private MvcSecurityPasswordEncode getMvcSecurityPasswordEncode(
			String sourceId) {

		Logger.info("Source Id :" + sourceId);

		if (mvcSecurityPasswordEncodeMappers.containsKey(sourceId)) {
			return mvcSecurityPasswordEncodeMappers.get(sourceId);
		}

		return mvcSecurityPasswordEncodeMappers
				.get(MvcSecurityPasswordEncode.Encode_For_All_Applications);
	}

	public void afterPropertiesSet() throws Exception {

		mvcSecurityPasswordEncodeMappers = CollectionsUtil
				.convertCollectionToMapByFieldNames(mvcSecurityPasswordEncodes,
						"accountSourceId");

		mvcSecurityPasswordEncodes.clear();

		Logger
				.info("-----------------------MvcSecurityPasswordEncode Mapper Start------------------------------");
		Logger.info(mvcSecurityPasswordEncodeMappers);
		Logger
				.info("-----------------------MvcSecurityPasswordEncode Mapper End------------------------------");

	}

	private Map<String, MvcSecurityPasswordEncode> mvcSecurityPasswordEncodeMappers = ObjectUtils.EMPTY_MAP;

	@Autowired(required = false)
	private List<MvcSecurityPasswordEncode> mvcSecurityPasswordEncodes = new ArrayList<MvcSecurityPasswordEncode>(
			5);

	private static final Log Logger = LogFactory
			.getLog(MvcSecurityPasswordEncodeFactory.class);

}
