package com.rapid.j2ee.framework.mvc.security.passsword;

import com.rapid.j2ee.framework.core.cryptology.CryptologyFactory;
import com.rapid.j2ee.framework.core.cryptology.CryptologyType;
import com.rapid.j2ee.framework.core.cryptology.single.SingleCryptology;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public class MvcSecurityPasswordMd5Encode extends
		AbstractMvcSecurityPasswordEncode {

	@Override
	protected String doEnryptPassword(String pwd) {

		SingleCryptology md5 = CryptologyFactory
				.getSingleCryptology(CryptologyType.Md5);

		pwd = this.getSaltPassword(pwd);

		for (int i = 1; i <= this.md5Count; i++) {
			pwd = md5.encrypt(pwd);
		}

		return pwd;
	}

	public void setMd5Count(int md5Count) {
		this.md5Count = md5Count;
	}

	public void setSaltExpression(String saltExpression) {
		this.saltExpression = saltExpression;
	}

	private String getSaltPassword(String pwd) {
		return TypeChecker.isEmpty(this.saltExpression) ? pwd : StringUtils
				.replaceStringIgnoreCase(this.saltExpression, "{pwd}", pwd);
	}

	private String saltExpression;

	private int md5Count = 1;

}
