package com.rapid.j2ee.framework.mvc.security.utils;

import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.opensymphony.xwork2.ActionContext;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.mvc.security.domain.WebUser;
import com.rapid.j2ee.framework.mvc.security.domain.WebUserTokenSession;
import com.rapid.j2ee.framework.mvc.security.menu.MenuTree;
import com.rapid.j2ee.framework.mvc.utils.ActionContextUtils;

public class MvcSecurityActionContextUtils {

	private static ThreadLocal<WebUser> batchJobWebUserLocal = new ThreadLocal<WebUser>();

	public static boolean isLoginState() {

		if (isBeforeLoginStage()) {
			return false;
		}

		return !TypeChecker.isNull(getWebUser());
	}

	public static boolean isBeforeLoginStage() {

		return ActionContextUtils.isBeforeLoginStage();
	}

	public static void setBatchJobWebUser(WebUser webUser) {
		batchJobWebUserLocal.set(webUser);
	}

	public static WebUser getWebUser() {

		try {

			WebUser webUser = batchJobWebUserLocal.get();

			if (!TypeChecker.isNull(webUser)) {
				return webUser;
			}

			webUser = getWebUserByContext();

			if (!TypeChecker.isNull(webUser)) {
				return webUser;
			}

			return getWebUserBySession();

		} catch (Exception e) {

			return null;
		}

	}

	private static WebUser getWebUserByContext() {

		try {

			if (TypeChecker.isNull(ActionContext.getContext())) {
				return null;
			}

			return (WebUser) ActionContext.getContext().get(
					WebUser.class.getName());
		} catch (Exception e) {

			return null;
		}

	}

	private static WebUser getWebUserBySession() {

		try {

			if (TypeChecker.isNull(ActionContext.getContext())) {
				return null;
			}

			if (ActionContextUtils.getHttpRequest().getSession(false) == null) {
				return null;
			}

			return (WebUser) ActionContextUtils.getHttpSession().getAttribute(
					WebUser.class.getName());
		} catch (Exception e) {

			return null;
		}
	}

	public static void setWebUser(WebUser webUser, boolean sessionMandatory) {

		removeBatchJobWebUser();

		ActionContext.getContext().put(WebUser.class.getName(), webUser);

		if (sessionMandatory) {

			ActionContextUtils.getHttpSession().setAttribute(
					WebUser.class.getName(), webUser);

			Logger.info("Save Web User Session Key:" + WebUser.class.getName());

			if (webUser != null) {
				Logger.info("Save Web User Class:"
						+ webUser.getClass().getName());
			}

		}

	}

	public static void removeBatchJobWebUser() {
		batchJobWebUserLocal.remove();
	}

	public static void removeWebUser() {

		batchJobWebUserLocal.remove();

		try {
			ActionContext.getContext().put(WebUser.class.getName(), null);

			ActionContextUtils.getHttpSession().setAttribute(
					WebUser.class.getName(), null);
		} catch (Exception e) {

		}
	}

	public static void setAccessibleFunctionPoints(List functionPoints) {

		ActionContextUtils.getHttpSession().setAttribute(
				WebUser.class.getName() + "_AccessibleFunctionPoints",
				functionPoints);

		Logger.info("Save Accessible Function Points Session Key:"
				+ WebUser.class.getName() + "_AccessibleFunctionPoints");
	}

	public static void setAccessibleFunctionPointsToActionContext(
			List functionPoints) {
		ActionContextUtils.getStrutActionContext().put(
				WebUser.class.getName() + "_AccessibleFunctionPoints",
				functionPoints);
	}

	public static <T> List<T> getAccessibleFunctionPointsFromActionContext(
			Class<T> functionPoint) {
		return (List<T>) ActionContextUtils.getStrutActionContext().get(
				WebUser.class.getName() + "_AccessibleFunctionPoints");
	}

	public static <T> List<T> getAccessibleFunctionPoints(Class<T> functionPoint) {
		return (List<T>) ActionContextUtils.getHttpSession().getAttribute(
				WebUser.class.getName() + "_AccessibleFunctionPoints");
	}

	public static void setAccessibleMenuTree(MenuTree menuTree) {

		ActionContextUtils.getHttpSession().setAttribute(
				WebUser.class.getName() + "_AccessibleMenuTree", menuTree);

		Logger.info("Save Accessible Menu Tree Session Key:"
				+ WebUser.class.getName() + "_AccessibleMenuTree");

	}

	public static MenuTree getAccessibleMenuTree() {
		return (MenuTree) ActionContextUtils.getHttpSession().getAttribute(
				WebUser.class.getName() + "_AccessibleMenuTree");
	}

	public static void saveWebUserTokenSession(
			WebUserTokenSession webUserTokenSession) {
		ActionContextUtils.getStrutActionContext().put(
				WebUserTokenSession.class.getName(), webUserTokenSession);
	}

	public static WebUserTokenSession getWebUserTokenSession() {
		return (WebUserTokenSession) ActionContextUtils.getStrutActionContext()
				.get(WebUserTokenSession.class.getName());
	}

	protected MvcSecurityActionContextUtils() {

	}

	private static final Log Logger = LogFactory
			.getLog(MvcSecurityActionContextUtils.class);

}
