package com.rapid.j2ee.framework.mvc.security.version;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.mvc.constants.OperationResultConstants;
import com.rapid.j2ee.framework.mvc.exception.MvcMethodContextApplicationException;
import com.rapid.j2ee.framework.mvc.utils.ActionContextUtils;
import com.rapid.j2ee.framework.mvc.web.context.MvcMethodGeneralBodyContext;
import com.rapid.j2ee.framework.mvc.web.context.resolve.MvcMethodContextOutputFormatResolver;
import com.rapid.j2ee.framework.mvc.web.context.resolve.MvcMethodContextOutputFormatResolverAdapter;

public abstract class AbstractMvcApplicationVersionVerfication<T> implements
		MvcApplicationVersionVerfication {

	public void checkApplicationVersion(HttpServletRequest request) {

		if (!this.isApplicationVersionDetectionRequried()) {
			return;
		}

		MvcMethodGeneralBodyContext<T> mvcMethodGeneralBodyContext = this
				.doCheckApplicationVersion(
						new MvcMethodGeneralBodyContext<T>(),
						ActionContextUtils
								.getHttpParameter(parameterPlatformIdName),
						ActionContextUtils
								.getHttpParameter(parameterPlatformVersionName),
						ActionContextUtils
								.getHttpParameter(parameterClientDeviceTypeName));

		if (TypeChecker.isNull(mvcMethodGeneralBodyContext)
				|| mvcMethodGeneralBodyContext.isEmpty()) {
			return;
		}

		throw new MvcMethodContextApplicationException(
				OperationResultConstants.FAILED_APPLICATION_VERSION_EXPIRED,
				mvcMethodGeneralBodyContext);

	}

	protected abstract MvcMethodGeneralBodyContext<T> doCheckApplicationVersion(
			MvcMethodGeneralBodyContext<T> mvcMethodGeneralBodyContext,
			String platformId, String appVersion, String deviceType);

	private boolean isApplicationVersionDetectionRequried() {

		Log
				.info("isApplicationVersionDetectionRequried parameterPlatformIdName:"
						+ parameterPlatformIdName
						+ " parameterPlatformVersionName: "
						+ parameterPlatformVersionName
						+ " parameterClientDeviceTypeName:"
						+ parameterClientDeviceTypeName);

		if (StringUtils.containsIgnoreCase(
				ignoreApplicationVersionVerficationPlatforms,
				ActionContextUtils.getHttpParameter(parameterPlatformIdName),
				",")) {

			return false;
		}

		return !TypeChecker.isEmpty(ActionContextUtils
				.getHttpParameter(parameterPlatformIdName))
				&& !TypeChecker.isEmpty(ActionContextUtils
						.getHttpParameter(parameterPlatformVersionName))
				&& !TypeChecker.isEmpty(ActionContextUtils
						.getHttpParameter(parameterClientDeviceTypeName));
	}

	public void setParameterPlatformVersionName(
			String parameterPlatformVersionName) {
		this.parameterPlatformVersionName = parameterPlatformVersionName;
	}

	public void setParameterClientDeviceTypeName(
			String parameterClientDeviceTypeName) {
		this.parameterClientDeviceTypeName = parameterClientDeviceTypeName;
	}

	public void setParameterPlatformIdName(String parameterPlatformIdName) {
		this.parameterPlatformIdName = parameterPlatformIdName;
	}

	public void setIgnoreApplicationVersionVerficationPlatforms(
			String ignoreApplicationVersionVerficationPlatforms) {
		this.ignoreApplicationVersionVerficationPlatforms = ignoreApplicationVersionVerficationPlatforms;
	}

	private String parameterPlatformIdName = "platformId";

	private String parameterPlatformVersionName = "appVersion";

	private String parameterClientDeviceTypeName = "deviceType";

	private String ignoreApplicationVersionVerficationPlatforms = "ignoreApplicationVersionVerficationPlatforms";

	protected final Log Log = LogFactory.getLog(this.getClass());

}
