package com.rapid.j2ee.framework.mvc.ui.complexview.datasource;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import com.rapid.j2ee.framework.core.utils.RequestUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.mvc.ui.annotation.RequestResourceProvider;

public abstract class AbstractComplexWebViewComponentDataSource<T> implements
		ComplexWebViewComponentDataSource,
		ComplexWebViewComponentLayoutProperties {

	public List<? extends WebViewComponentItem> getDataSource(
			HttpServletRequest request) {

		Class beanRequestClass = this.getClass().getAnnotation(
				RequestResourceProvider.class).requestBeanClass();

		if (beanRequestClass == Object.class) {
			return this.getDataSource(request, null);
		}

		return this.getDataSource(request, (T) RequestUtils.convertBean(
				request, beanRequestClass));
	}

	protected abstract List<? extends WebViewComponentItem> getDataSource(
			HttpServletRequest request, T requestBean);

	public String getWebViewRemark(HttpServletRequest request) {

		return StringUtils.trimToEmpty(request.getParameter("WebViewRemark"));
	}

	public String getWebViewTitle(HttpServletRequest request) {

		return StringUtils.trimToEmpty(request.getParameter("WebViewTitle"));
	}

	public String getContainerWidth(HttpServletRequest request) {
		return StringUtils.trimToEmpty(request.getParameter("containerWidth"));
	}

	public String getContainerHeight(HttpServletRequest request) {
		return StringUtils.trimToEmpty(request.getParameter("containerHeight"));
	}

	public String getItemWidth(HttpServletRequest request) {
		return StringUtils.trimToEmpty(request.getParameter("itemWidth"));
	}

	public String getContainerAlign(HttpServletRequest request) {

		return StringUtils.trimToEmpty(request.getParameter("containerAlign"));
	}
}
