package com.rapid.j2ee.framework.mvc.ui.complexview.datasource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

import com.rapid.j2ee.framework.core.utils.ObjectUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.mvc.ui.annotation.RequestResourceProvider;

/**
 * 
 * 用于复杂WebView组件的数据源的统一加载和实例化， 同时提供getComplexWebViewComponentDataSource（String
 * dataSourceName） 获得指定的数据源
 * 
 * @author John Hao
 * 
 */
public class ComplexWebViewComponentDataSourceFactory implements
		InitializingBean {

	public void afterPropertiesSet() throws Exception {

		if (TypeChecker.isEmpty(complexWebViewComponentDataSources)) {
			return;
		}

		for (ComplexWebViewComponentDataSource ds : complexWebViewComponentDataSources) {

			Assert.isTrue(ds.getClass().isAnnotationPresent(
					RequestResourceProvider.class),
					"Please privide @RequestResourceProvider at "
							+ ds.getClass().getSimpleName() + "!");

			complexWebViewComponentDataSourcesMapper.put(ds.getClass()
					.getAnnotation(RequestResourceProvider.class).value(), ds);
		}
	}

	public ComplexWebViewComponentDataSource getComplexWebViewComponentDataSource(
			String dataSourceName) {
		return complexWebViewComponentDataSourcesMapper.get(dataSourceName);
	}

	/**
	 * 获得数据源
	 * 
	 * @param dataSourceName
	 * @param request
	 * @return
	 */
	public List<WebViewComponentItemPinYinWrapper> getDataSourceWrappedByPinYin(
			String dataSourceName, HttpServletRequest request) {

		Assert.notNull(getComplexWebViewComponentDataSource(dataSourceName),
				"Please setup a datasource name[" + dataSourceName + "]");

		List<? extends WebViewComponentItem> items = getComplexWebViewComponentDataSource(
				dataSourceName).getDataSource(request);

		if (TypeChecker.isEmpty(items)) {
			return ObjectUtils.EMPTY_LIST;
		}

		List<WebViewComponentItemPinYinWrapper> itemsWrappedByPinYin = new ArrayList<WebViewComponentItemPinYinWrapper>(
				items.size());

		for (WebViewComponentItem item : items) {
			itemsWrappedByPinYin
					.add(new WebViewComponentItemPinYinWrapper(item));
		}

		Collections.sort(itemsWrappedByPinYin);

		return itemsWrappedByPinYin;
	}

	@Autowired(required = false)
	private List<ComplexWebViewComponentDataSource> complexWebViewComponentDataSources;

	private Map<String, ComplexWebViewComponentDataSource> complexWebViewComponentDataSourcesMapper = new HashMap<String, ComplexWebViewComponentDataSource>();

}
